/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.libs.org.parboiled.common;

import java.util.Arrays;

public class Base64 {
    private static Base64 RFC2045;
    private static Base64 CUSTOM;
    private final char[] CA;
    private final int[] IA;
    private final char fillChar;

    public static Base64 custom() {
        if (CUSTOM == null) {
            CUSTOM = new Base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-_");
        }
        return CUSTOM;
    }

    public static Base64 rfc2045() {
        if (RFC2045 == null) {
            RFC2045 = new Base64("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=");
        }
        return RFC2045;
    }

    public Base64(String alphabet) {
        if (alphabet == null || alphabet.length() != 65) {
            throw new IllegalArgumentException();
        }
        this.CA = alphabet.substring(0, 64).toCharArray();
        this.IA = new int[256];
        Arrays.fill(this.IA, -1);
        int iS = this.CA.length;
        for (int i = 0; i < iS; ++i) {
            this.IA[this.CA[i]] = i;
        }
        this.fillChar = alphabet.charAt(64);
        this.IA[this.fillChar] = 0;
    }

    public final byte[] decode(char[] sArr) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int sepCnt = 0;
        for (int i = 0; i < sLen; ++i) {
            if (this.IA[sArr[i]] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && this.IA[sArr[--i]] <= 0) {
            if (sArr[i] != this.fillChar) continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = this.IA[sArr[s++]]) >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    public final byte[] decode(byte[] sArr) {
        int sLen = sArr.length;
        int sepCnt = 0;
        for (int i = 0; i < sLen; ++i) {
            if (this.IA[sArr[i] & 0xFF] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && this.IA[sArr[--i] & 0xFF] <= 0) {
            if (sArr[i] != this.fillChar) continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = this.IA[sArr[s++] & 0xFF]) >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    public final byte[] decode(String str) {
        int sLen;
        int n = sLen = str != null ? str.length() : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int sepCnt = 0;
        for (int i = 0; i < sLen; ++i) {
            if (this.IA[str.charAt(i)] >= 0) continue;
            ++sepCnt;
        }
        if ((sLen - sepCnt) % 4 != 0) {
            return null;
        }
        int pad = 0;
        int i = sLen;
        while (i > 1 && this.IA[str.charAt(--i)] <= 0) {
            if (str.charAt(i) != this.fillChar) continue;
            ++pad;
        }
        int len = ((sLen - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int s = 0;
        int d = 0;
        while (d < len) {
            int i2 = 0;
            for (int j = 0; j < 4; ++j) {
                int c;
                if ((c = this.IA[str.charAt(s++)]) >= 0) {
                    i2 |= c << 18 - j * 6;
                    continue;
                }
                --j;
            }
            dArr[d++] = (byte)(i2 >> 16);
            if (d >= len) continue;
            dArr[d++] = (byte)(i2 >> 8);
            if (d >= len) continue;
            dArr[d++] = (byte)i2;
        }
        return dArr;
    }

    public final byte[] decodeFast(char[] sArr) {
        int sIx;
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && this.IA[sArr[sIx]] < 0; ++sIx) {
        }
        while (eIx > 0 && this.IA[sArr[eIx]] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == this.fillChar ? (sArr[eIx - 1] == this.fillChar ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = this.IA[sArr[sIx++]] << 18 | this.IA[sArr[sIx++]] << 12 | this.IA[sArr[sIx++]] << 6 | this.IA[sArr[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= this.IA[sArr[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public final byte[] decodeFast(byte[] sArr) {
        int sIx;
        int sLen = sArr.length;
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && this.IA[sArr[sIx] & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && this.IA[sArr[eIx] & 0xFF] < 0) {
            --eIx;
        }
        int pad = sArr[eIx] == this.fillChar ? (sArr[eIx - 1] == this.fillChar ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (sArr[76] == 13 ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = this.IA[sArr[sIx++]] << 18 | this.IA[sArr[sIx++]] << 12 | this.IA[sArr[sIx++]] << 6 | this.IA[sArr[sIx++]];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= this.IA[sArr[sIx++]] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public final byte[] decodeFast(String s) {
        int sIx;
        int sLen = s.length();
        if (sLen == 0) {
            return new byte[0];
        }
        int eIx = sLen - 1;
        for (sIx = 0; sIx < eIx && this.IA[s.charAt(sIx) & 0xFF] < 0; ++sIx) {
        }
        while (eIx > 0 && this.IA[s.charAt(eIx) & 0xFF] < 0) {
            --eIx;
        }
        int pad = s.charAt(eIx) == this.fillChar ? (s.charAt(eIx - 1) == this.fillChar ? 2 : 1) : 0;
        int cCnt = eIx - sIx + 1;
        int sepCnt = sLen > 76 ? (s.charAt(76) == '\r' ? cCnt / 78 : 0) << 1 : 0;
        int len = ((cCnt - sepCnt) * 6 >> 3) - pad;
        byte[] dArr = new byte[len];
        int d = 0;
        int cc = 0;
        int eLen = len / 3 * 3;
        while (d < eLen) {
            int i = this.IA[s.charAt(sIx++)] << 18 | this.IA[s.charAt(sIx++)] << 12 | this.IA[s.charAt(sIx++)] << 6 | this.IA[s.charAt(sIx++)];
            dArr[d++] = (byte)(i >> 16);
            dArr[d++] = (byte)(i >> 8);
            dArr[d++] = (byte)i;
            if (sepCnt <= 0 || ++cc != 19) continue;
            sIx += 2;
            cc = 0;
        }
        if (d < len) {
            int i = 0;
            int j = 0;
            while (sIx <= eIx - pad) {
                i |= this.IA[s.charAt(sIx++)] << 18 - j * 6;
                ++j;
            }
            int r = 16;
            while (d < len) {
                dArr[d++] = (byte)(i >> r);
                r -= 8;
            }
        }
        return dArr;
    }

    public final byte[] encodeToByte(byte[] sArr, boolean lineSep) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new byte[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        byte[] dArr = new byte[dLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = (byte)this.CA[i >>> 18 & 0x3F];
            dArr[d++] = (byte)this.CA[i >>> 12 & 0x3F];
            dArr[d++] = (byte)this.CA[i >>> 6 & 0x3F];
            dArr[d++] = (byte)this.CA[i & 0x3F];
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = (byte)this.CA[i >> 12];
            dArr[dLen - 3] = (byte)this.CA[i >>> 6 & 0x3F];
            dArr[dLen - 2] = left == 2 ? (byte)this.CA[i & 0x3F] : (byte)this.fillChar;
            dArr[dLen - 1] = (byte)this.fillChar;
        }
        return dArr;
    }

    public final String encodeToString(byte[] sArr, boolean lineSep) {
        return new String(this.encodeToChar(sArr, lineSep));
    }

    public final char[] encodeToChar(byte[] sArr, boolean lineSep) {
        int sLen;
        int n = sLen = sArr != null ? sArr.length : 0;
        if (sLen == 0) {
            return new char[0];
        }
        int eLen = sLen / 3 * 3;
        int cCnt = (sLen - 1) / 3 + 1 << 2;
        int dLen = cCnt + (lineSep ? (cCnt - 1) / 76 << 1 : 0);
        char[] dArr = new char[dLen];
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < eLen) {
            int i = (sArr[s++] & 0xFF) << 16 | (sArr[s++] & 0xFF) << 8 | sArr[s++] & 0xFF;
            dArr[d++] = this.CA[i >>> 18 & 0x3F];
            dArr[d++] = this.CA[i >>> 12 & 0x3F];
            dArr[d++] = this.CA[i >>> 6 & 0x3F];
            dArr[d++] = this.CA[i & 0x3F];
            if (!lineSep || ++cc != 19 || d >= dLen - 2) continue;
            dArr[d++] = 13;
            dArr[d++] = 10;
            cc = 0;
        }
        int left = sLen - eLen;
        if (left > 0) {
            int i = (sArr[eLen] & 0xFF) << 10 | (left == 2 ? (sArr[sLen - 1] & 0xFF) << 2 : 0);
            dArr[dLen - 4] = this.CA[i >> 12];
            dArr[dLen - 3] = this.CA[i >>> 6 & 0x3F];
            dArr[dLen - 2] = left == 2 ? this.CA[i & 0x3F] : this.fillChar;
            dArr[dLen - 1] = this.fillChar;
        }
        return dArr;
    }

    public char[] getAlphabet() {
        return this.CA;
    }
}

