/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.emma.report.ClassItem;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.IItemVisitor;
import com.vladium.emma.report.Item;
import com.vladium.emma.report.MethodItem;
import com.vladium.util.IntObjectMap;
import java.io.Serializable;
import java.util.Iterator;

public final class SrcFileItem
extends Item {
    private final String m_name;
    private final String m_fullVMName;
    private IntObjectMap m_lineCoverage;
    private int m_firstLine;
    private static final Item.ItemMetadata METADATA = new Item.ItemMetadata(2, "srcfile", 31L);

    public SrcFileItem(IItem iItem, String string, String string2) {
        super(iItem);
        this.m_name = string;
        this.m_fullVMName = string2;
    }

    public String getName() {
        return this.m_name;
    }

    public String getFullVMName() {
        return this.m_fullVMName;
    }

    public int getFirstLine() {
        if (this.m_firstLine == 0) {
            this.getAggregate(7);
        }
        return this.m_firstLine;
    }

    public IntObjectMap getLineCoverage() {
        if (this.m_lineCoverage == null) {
            this.getAggregate(7);
        }
        return this.m_lineCoverage;
    }

    public int getAggregate(int n) {
        int[] nArray = this.m_aggregates;
        int n2 = nArray[n];
        if (n2 < 0) {
            switch (n) {
                case 5: 
                case 11: {
                    nArray[11] = this.getChildCount();
                    n2 = 0;
                    Iterator iterator = this.getChildren();
                    while (iterator.hasNext()) {
                        n2 += ((IItem)iterator.next()).getAggregate(5);
                    }
                    nArray[5] = n2;
                    return nArray[n];
                }
                case 12: {
                    nArray[12] = 1;
                    return 1;
                }
                case 1: 
                case 3: 
                case 7: {
                    int n3;
                    Object[] objectArray;
                    Object object;
                    Object object2;
                    Serializable serializable;
                    IntObjectMap intObjectMap = new IntObjectMap();
                    Iterator iterator = this.getChildren();
                    while (iterator.hasNext()) {
                        ClassItem classItem = (ClassItem)iterator.next();
                        boolean[][] blArray = classItem.getCoverage();
                        serializable = classItem.getClassDescriptor();
                        MethodDescriptor[] methodDescriptorArray = ((ClassDescriptor)serializable).getMethods();
                        object2 = classItem.getChildren();
                        while (object2.hasNext()) {
                            MethodItem methodItem = (MethodItem)object2.next();
                            object = methodItem.getID();
                            objectArray = blArray == null ? null : blArray[object];
                            MethodDescriptor methodDescriptor = methodDescriptorArray[object];
                            int[] nArray2 = methodDescriptor.getBlockSizes();
                            IntObjectMap intObjectMap2 = methodDescriptor.getLineMap();
                            for (int n4 : intObjectMap2.keys()) {
                                int[] nArray3 = (int[])intObjectMap.get(n4);
                                if (nArray3 == null) {
                                    nArray3 = new int[4];
                                    intObjectMap.put(n4, nArray3);
                                }
                                int[] nArray4 = (int[])intObjectMap2.get(n4);
                                int n5 = nArray4.length;
                                nArray3[0] = nArray3[0] + n5;
                                for (int i = 0; i < n5; ++i) {
                                    int n6 = nArray4[i];
                                    boolean bl = objectArray != null && objectArray[n6];
                                    int n7 = nArray2[n6];
                                    nArray3[1] = nArray3[1] + n7;
                                    if (!bl) continue;
                                    nArray3[2] = nArray3[2] + 1;
                                    nArray3[3] = nArray3[3] + n7;
                                }
                            }
                        }
                    }
                    nArray[7] = n3 = intObjectMap.size();
                    int n8 = 0;
                    int n9 = 0;
                    serializable = new IntObjectMap(n3);
                    int n10 = Integer.MAX_VALUE;
                    object2 = intObjectMap.keys();
                    for (int i = 0; i < n3; ++i) {
                        int n11;
                        object = object2[i];
                        objectArray = (int[])intObjectMap.get((int)object);
                        int n12 = objectArray[0];
                        int n13 = objectArray[1];
                        int n14 = objectArray[2];
                        int n15 = objectArray[3];
                        if (n15 > 0) {
                            n8 += 100 * n14 / n12;
                            n9 += 100 * n15 / n13;
                        }
                        Object object3 = null;
                        if (n15 == 0) {
                            n11 = 0;
                        } else if (n15 == n13) {
                            n11 = 2;
                        } else {
                            n11 = 1;
                            object3 = new int[][]{{n12, n14}, {n13, n15}};
                        }
                        ((IntObjectMap)serializable).put((int)object, new LineCoverageData(n11, (int[][])object3));
                        if (object >= n10) continue;
                        n10 = object;
                    }
                    this.m_lineCoverage = serializable;
                    this.m_firstLine = n10;
                    nArray[1] = n8;
                    nArray[3] = n9;
                    return nArray[n];
                }
            }
            return super.getAggregate(n);
        }
        return n2;
    }

    public void accept(IItemVisitor iItemVisitor, Object object) {
        iItemVisitor.visit(this, object);
    }

    public final IItemMetadata getMetadata() {
        return METADATA;
    }

    public static IItemMetadata getTypeMetadata() {
        return METADATA;
    }

    public final class LineCoverageData {
        public static final int LINE_COVERAGE_ZERO = 0;
        public static final int LINE_COVERAGE_PARTIAL = 1;
        public static final int LINE_COVERAGE_COMPLETE = 2;
        public final int m_coverageStatus;
        public final int[][] m_coverageRatio;

        LineCoverageData(int n, int[][] nArray) {
            this.m_coverageStatus = n;
            this.m_coverageRatio = nArray;
        }
    }
}

