/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.rt;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.IAppConstants;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.rt.RTCoverageDataPersister;
import com.vladium.emma.rt.RTExitHook;
import com.vladium.emma.rt.RTSettings;
import com.vladium.logging.Logger;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.exit.ExitHookManager;
import java.io.File;

public abstract class RT
implements IAppConstants {
    private static ICoverageData s_cdata;
    private static Runnable s_exitHook;
    private static IProperties s_appProperties;
    private static final ExitHookManager EXIT_HOOK_MANAGER;
    private static final boolean DEBUG = false;

    public static synchronized ICoverageData reset(boolean bl, boolean bl2) {
        ClassLoader classLoader = RT.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        IProperties iProperties = null;
        try {
            iProperties = EMMAProperties.getAppProperties(classLoader);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        s_appProperties = iProperties;
        if (EXIT_HOOK_MANAGER != null && s_exitHook != null) {
            EXIT_HOOK_MANAGER.removeExitHook(s_exitHook);
            s_exitHook = null;
        }
        ICoverageData iCoverageData = s_cdata;
        s_cdata = bl ? (iCoverageData = DataFactory.newCoverageData()) : null;
        if (EXIT_HOOK_MANAGER != null && bl2 && iCoverageData != null) {
            RTExitHook rTExitHook = new RTExitHook(RT.class, iCoverageData, RT.getCoverageOutFile(), RT.getCoverageOutMerge());
            RTExitHook.createClassLoaderClosure();
            if (EXIT_HOOK_MANAGER.addExitHook(rTExitHook)) {
                s_exitHook = rTExitHook;
            }
        }
        return iCoverageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void r(boolean[][] blArray, String string, long l) {
        ICoverageData iCoverageData = RT.getCoverageData();
        if (iCoverageData != null) {
            Object object = iCoverageData.lock();
            synchronized (object) {
                iCoverageData.addClass(blArray, string, l);
            }
        }
    }

    public static synchronized ICoverageData getCoverageData() {
        return s_cdata;
    }

    public static synchronized IProperties getAppProperties() {
        return s_appProperties;
    }

    public static synchronized void dumpCoverageData(File file, boolean bl, boolean bl2) {
        file = file != null ? file : RT.getCoverageOutFile();
        ICoverageData iCoverageData = s_cdata;
        if (bl2) {
            s_cdata = null;
        }
        RTCoverageDataPersister.dumpCoverageData(iCoverageData, !bl2, file, bl);
    }

    public static synchronized void dumpCoverageData(File file, boolean bl) {
        file = file != null ? file : RT.getCoverageOutFile();
        ICoverageData iCoverageData = s_cdata;
        if (bl) {
            s_cdata = null;
        }
        RTCoverageDataPersister.dumpCoverageData(iCoverageData, !bl, file, RT.getCoverageOutMerge());
    }

    private RT() {
    }

    private static File getCoverageOutFile() {
        IProperties iProperties = RT.getAppProperties();
        if (iProperties != null) {
            String string = iProperties.getProperty("coverage.out.file", "coverage.ec");
            return new File(string);
        }
        return new File("coverage.ec");
    }

    private static boolean getCoverageOutMerge() {
        IProperties iProperties = RT.getAppProperties();
        if (iProperties != null) {
            String string = iProperties.getProperty("coverage.out.merge", EMMAProperties.DEFAULT_COVERAGE_DATA_OUT_MERGE.toString());
            return Property.toBoolean(string);
        }
        return EMMAProperties.DEFAULT_COVERAGE_DATA_OUT_MERGE;
    }

    static {
        ExitHookManager exitHookManager = null;
        try {
            exitHookManager = ExitHookManager.getSingleton();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
        }
        EXIT_HOOK_MANAGER = exitHookManager;
        if (RTSettings.isStandaloneMode()) {
            RT.reset(true, true);
            Logger logger = Logger.getLogger();
            if (logger.atINFO()) {
                logger.info("collecting runtime coverage data ...");
            }
        } else {
            RT.reset(false, false);
        }
    }
}

