/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.IInterfaceCollection;
import com.vladium.jcd.lib.UDataOutputStream;
import com.vladium.util.IntVector;
import java.io.IOException;

final class InterfaceCollection
implements IInterfaceCollection {
    private IntVector m_interfaces;

    public int get(int n) {
        return this.m_interfaces.get(n);
    }

    public int size() {
        return this.m_interfaces.size();
    }

    public Object clone() {
        try {
            InterfaceCollection interfaceCollection = (InterfaceCollection)super.clone();
            interfaceCollection.m_interfaces = (IntVector)this.m_interfaces.clone();
            return interfaceCollection;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        int n = this.m_interfaces.size();
        uDataOutputStream.writeU2(n);
        for (int i = 0; i < n; ++i) {
            uDataOutputStream.writeU2(this.get(i));
        }
    }

    public void accept(IClassDefVisitor iClassDefVisitor, Object object) {
        iClassDefVisitor.visit(this, object);
    }

    public int add(int n) {
        int n2 = this.m_interfaces.size();
        this.m_interfaces.add(n);
        return n2;
    }

    public int set(int n, int n2) {
        return this.m_interfaces.set(n, n2);
    }

    InterfaceCollection(int n) {
        this.m_interfaces = n < 0 ? new IntVector() : new IntVector(n);
    }
}

