/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls.attribute;

import com.vladium.jcd.cls.ClassDef;
import com.vladium.jcd.cls.IConstantCollection;
import com.vladium.jcd.cls.attribute.BridgeAttribute_info;
import com.vladium.jcd.cls.attribute.CodeAttribute_info;
import com.vladium.jcd.cls.attribute.ConstantValueAttribute_info;
import com.vladium.jcd.cls.attribute.ExceptionsAttribute_info;
import com.vladium.jcd.cls.attribute.GenericAttribute_info;
import com.vladium.jcd.cls.attribute.IAttributeVisitor;
import com.vladium.jcd.cls.attribute.InnerClassesAttribute_info;
import com.vladium.jcd.cls.attribute.LineNumberTableAttribute_info;
import com.vladium.jcd.cls.attribute.SourceFileAttribute_info;
import com.vladium.jcd.cls.attribute.SyntheticAttribute_info;
import com.vladium.jcd.cls.constant.CONSTANT_Utf8_info;
import com.vladium.jcd.compiler.IClassFormatOutput;
import com.vladium.jcd.lib.UDataInputStream;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;

public abstract class Attribute_info
implements Cloneable,
IClassFormatOutput {
    public static final String ATTRIBUTE_CODE = "Code";
    public static final String ATTRIBUTE_CONSTANT_VALUE = "ConstantValue";
    public static final String ATTRIBUTE_LINE_NUMBER_TABLE = "LineNumberTable";
    public static final String ATTRIBUTE_EXCEPTIONS = "Exceptions";
    public static final String ATTRIBUTE_SYNTHETIC = "Synthetic";
    public static final String ATTRIBUTE_BRIDGE = "Bridge";
    public static final String ATTRIBUTE_SOURCEFILE = "SourceFile";
    public static final String ATTRIBUTE_INNERCLASSES = "InnerClasses";
    public int m_name_index;
    protected long m_attribute_length;

    public String getName(ClassDef classDef) {
        return ((CONSTANT_Utf8_info)classDef.getConstants().get((int)this.m_name_index)).m_value;
    }

    public abstract long length();

    public abstract void accept(IAttributeVisitor var1, Object var2);

    public abstract String toString();

    public static Attribute_info new_Attribute_info(IConstantCollection iConstantCollection, UDataInputStream uDataInputStream) throws IOException {
        int n = uDataInputStream.readU2();
        long l = uDataInputStream.readU4();
        CONSTANT_Utf8_info cONSTANT_Utf8_info = (CONSTANT_Utf8_info)iConstantCollection.get(n);
        String string = cONSTANT_Utf8_info.m_value;
        if (ATTRIBUTE_CODE.equals(string)) {
            return new CodeAttribute_info(iConstantCollection, n, l, uDataInputStream);
        }
        if (ATTRIBUTE_CONSTANT_VALUE.equals(string)) {
            return new ConstantValueAttribute_info(n, l, uDataInputStream);
        }
        if (ATTRIBUTE_EXCEPTIONS.equals(string)) {
            return new ExceptionsAttribute_info(n, l, uDataInputStream);
        }
        if (ATTRIBUTE_INNERCLASSES.equals(string)) {
            return new InnerClassesAttribute_info(n, l, uDataInputStream);
        }
        if (ATTRIBUTE_SYNTHETIC.equals(string)) {
            return new SyntheticAttribute_info(n, l);
        }
        if (ATTRIBUTE_BRIDGE.equals(string)) {
            return new BridgeAttribute_info(n, l);
        }
        if (ATTRIBUTE_LINE_NUMBER_TABLE.equals(string)) {
            return new LineNumberTableAttribute_info(n, l, uDataInputStream);
        }
        if (ATTRIBUTE_SOURCEFILE.equals(string)) {
            return new SourceFileAttribute_info(n, l, uDataInputStream);
        }
        return new GenericAttribute_info(n, l, uDataInputStream);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream uDataOutputStream) throws IOException {
        uDataOutputStream.writeU2(this.m_name_index);
        uDataOutputStream.writeU4(this.length() - 6L);
    }

    protected Attribute_info(int n, long l) {
        this.m_name_index = n;
        this.m_attribute_length = l;
    }
}

