/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.logging.Logger;
import com.vladium.util.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public interface IPathEnumerator {
    public void enumerate() throws IOException;

    public static abstract class Factory {
        public static IPathEnumerator create(File[] fileArray, boolean bl, IPathHandler iPathHandler) {
            return new PathEnumerator(fileArray, bl, iPathHandler);
        }

        private static final class PathEnumerator
        implements IPathEnumerator {
            private final ArrayList m_path;
            private final boolean m_canonical;
            private final Set m_pathSet;
            private final IPathHandler m_handler;
            private final boolean m_processManifest;
            private final Logger m_log;
            private boolean m_verbose;
            private boolean m_trace1;
            private int m_pathIndex;
            private File m_currentPathDir;
            private static final boolean IGNORE_INVALID_ENTRIES = true;

            public void enumerate() throws IOException {
                IPathHandler iPathHandler = this.m_handler;
                this.m_pathIndex = 0;
                while (this.m_pathIndex < this.m_path.size()) {
                    File file = (File)this.m_path.get(this.m_pathIndex);
                    if (file.exists()) {
                        if (file.isDirectory()) {
                            if (this.m_verbose) {
                                this.m_log.verbose("processing dir path entry [" + file.getAbsolutePath() + "] ...");
                            }
                            this.m_currentPathDir = file;
                            this.enumeratePathDir(null);
                        } else {
                            String string = file.getName();
                            String string2 = string.toLowerCase();
                            if (string2.endsWith(".zip") || string2.endsWith(".jar")) {
                                if (this.m_verbose) {
                                    this.m_log.verbose("processing archive path entry [" + file.getAbsolutePath() + "] ...");
                                }
                                File file2 = file.getParentFile();
                                File file3 = new File(string);
                                this.m_currentPathDir = file2;
                                this.enumeratePathArchive(string);
                                iPathHandler.handleArchiveEnd(file2, file3);
                            }
                        }
                    }
                    ++this.m_pathIndex;
                }
            }

            PathEnumerator(File[] fileArray, boolean bl, IPathHandler iPathHandler) {
                int n;
                this.m_path = new ArrayList(fileArray.length);
                for (n = 0; n < fileArray.length; ++n) {
                    this.m_path.add(fileArray[n]);
                }
                this.m_canonical = bl;
                if (iPathHandler == null) {
                    throw new IllegalArgumentException("null input: handler");
                }
                this.m_handler = iPathHandler;
                this.m_processManifest = true;
                if (this.m_processManifest) {
                    this.m_pathSet = new HashSet(fileArray.length);
                    for (n = 0; n < fileArray.length; ++n) {
                        this.m_pathSet.add(fileArray[n].getPath());
                    }
                } else {
                    this.m_pathSet = null;
                }
                this.m_log = Logger.getLogger();
                this.m_verbose = this.m_log.atVERBOSE();
                this.m_trace1 = this.m_log.atTRACE1();
            }

            private void enumeratePathDir(String string) throws IOException {
                boolean bl = this.m_trace1;
                File file = this.m_currentPathDir;
                File file2 = string != null ? new File(file, string) : file;
                String[] stringArray = file2.list();
                IPathHandler iPathHandler = this.m_handler;
                for (String string2 : stringArray) {
                    File file3 = string != null ? new File(string, string2) : new File(string2);
                    File file4 = new File(file2, string2);
                    if (file4.isDirectory()) {
                        iPathHandler.handleDirStart(file, file3);
                        if (bl) {
                            this.m_log.trace1("enumeratePathDir", "recursing into [" + file3.getName() + "] ...");
                        }
                        this.enumeratePathDir(file3.getPath());
                        iPathHandler.handleDirEnd(file, file3);
                        continue;
                    }
                    if (bl) {
                        this.m_log.trace1("enumeratePathDir", "processing file [" + file3.getName() + "] ...");
                    }
                    iPathHandler.handleFile(file, file3);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void enumeratePathArchive(String string) throws IOException {
                boolean bl = this.m_trace1;
                File file = new File(this.m_currentPathDir, string);
                ZipInputStream zipInputStream = null;
                try {
                    Cloneable cloneable;
                    zipInputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(file), 32768));
                    IPathHandler iPathHandler = this.m_handler;
                    Manifest manifest = ((JarInputStream)zipInputStream).getManifest();
                    if (manifest == null) {
                        manifest = PathEnumerator.readManifestViaJarFile(file);
                    }
                    iPathHandler.handleArchiveStart(this.m_currentPathDir, new File(string), manifest);
                    while ((cloneable = ((JarInputStream)zipInputStream).getNextEntry()) != null) {
                        if (bl) {
                            this.m_log.trace1("enumeratePathArchive", "processing archive entry [" + ((ZipEntry)cloneable).getName() + "] ...");
                        }
                        iPathHandler.handleArchiveEntry((JarInputStream)zipInputStream, (ZipEntry)cloneable);
                        zipInputStream.closeEntry();
                    }
                    if (this.m_processManifest) {
                        String string2;
                        if (manifest == null) {
                            manifest = ((JarInputStream)zipInputStream).getManifest();
                        }
                        if (manifest != null && (cloneable = manifest.getMainAttributes()) != null && (string2 = ((Attributes)cloneable).getValue(Attributes.Name.CLASS_PATH)) != null) {
                            StringTokenizer stringTokenizer = new StringTokenizer(string2);
                            int n = 1;
                            while (stringTokenizer.hasMoreTokens()) {
                                String string3 = stringTokenizer.nextToken();
                                File file2 = file.getParentFile();
                                File file3 = file2 != null ? new File(file2, string3) : new File(string3);
                                String string4 = this.m_canonical ? Files.canonicalizePathname(file3.getPath()) : file3.getPath();
                                if (!this.m_pathSet.add(string4)) continue;
                                if (this.m_verbose) {
                                    this.m_log.verbose("  added manifest Class-Path entry [" + file3 + "]");
                                }
                                this.m_path.add(this.m_pathIndex + n++, file3);
                            }
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                finally {
                    if (zipInputStream != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static Manifest readManifestViaJarFile(File file) {
                Manifest manifest = null;
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(file, false);
                    manifest = jarFile.getManifest();
                }
                catch (IOException iOException) {
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return manifest;
            }
        }
    }

    public static interface IPathHandler {
        public void handleDirStart(File var1, File var2);

        public void handleFile(File var1, File var2);

        public void handleDirEnd(File var1, File var2);

        public void handleArchiveStart(File var1, File var2, Manifest var3);

        public void handleArchiveEntry(JarInputStream var1, ZipEntry var2);

        public void handleArchiveEnd(File var1, File var2);
    }
}

