/*
 * Decompiled with CFR 0.152.
 */
package de.waldheinz.fs.fat;

import de.waldheinz.fs.BlockDevice;
import de.waldheinz.fs.fat.Fat16BootSector;
import de.waldheinz.fs.fat.Fat32BootSector;
import de.waldheinz.fs.fat.FatType;
import de.waldheinz.fs.fat.FatUtils;
import de.waldheinz.fs.fat.Sector;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class BootSector
extends Sector {
    public static final int FAT_COUNT_OFFSET = 16;
    public static final int RESERVED_SECTORS_OFFSET = 14;
    public static final int TOTAL_SECTORS_16_OFFSET = 19;
    public static final int TOTAL_SECTORS_32_OFFSET = 32;
    public static final int FILE_SYSTEM_TYPE_LENGTH = 8;
    public static final int SECTORS_PER_CLUSTER_OFFSET = 13;
    public static final int EXTENDED_BOOT_SIGNATURE = 41;
    public static final int SIZE = 512;

    protected BootSector(BlockDevice device) {
        super(device, 0L, 512);
        this.markDirty();
    }

    public static BootSector read(BlockDevice device) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(512);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        device.read(0L, bb);
        if ((bb.get(510) & 0xFF) != 85 || (bb.get(511) & 0xFF) != 170) {
            throw new IOException("missing boot sector signature");
        }
        byte sectorsPerCluster = bb.get(13);
        if (sectorsPerCluster <= 0) {
            throw new IOException("suspicious sectors per cluster count " + sectorsPerCluster);
        }
        short rootDirEntries = bb.getShort(17);
        int rootDirSectors = (rootDirEntries * 32 + (device.getSectorSize() - 1)) / device.getSectorSize();
        int total16 = bb.getShort(19) & 0xFFFF;
        long total32 = (long)bb.getInt(32) & 0xFFFFFFFFL;
        long totalSectors = total16 == 0 ? total32 : (long)total16;
        int fatSz16 = bb.getShort(22) & 0xFFFF;
        long fatSz32 = (long)bb.getInt(36) & 0xFFFFFFFFL;
        long fatSz = fatSz16 == 0 ? fatSz32 : (long)fatSz16;
        short reservedSectors = bb.getShort(14);
        byte fatCount = bb.get(16);
        long dataSectors = totalSectors - ((long)reservedSectors + (long)fatCount * fatSz + (long)rootDirSectors);
        long clusterCount = dataSectors / (long)sectorsPerCluster;
        BootSector result = clusterCount > 65524L ? new Fat32BootSector(device) : new Fat16BootSector(device);
        result.read();
        return result;
    }

    public abstract FatType getFatType();

    public abstract long getSectorsPerFat();

    public abstract void setSectorsPerFat(long var1);

    public abstract void setSectorCount(long var1);

    public abstract int getRootDirEntryCount();

    public abstract long getSectorCount();

    public abstract int getFileSystemTypeLabelOffset();

    public abstract int getExtendedBootSignatureOffset();

    public void init() throws IOException {
        this.setBytesPerSector(this.getDevice().getSectorSize());
        this.setSectorCount(this.getDevice().getSize() / (long)this.getDevice().getSectorSize());
        this.set8(this.getExtendedBootSignatureOffset(), 41);
        this.set8(0, 235);
        this.set8(1, 60);
        this.set8(2, 144);
        this.set8(510, 85);
        this.set8(511, 170);
    }

    public String getFileSystemTypeLabel() {
        StringBuilder sb = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            sb.append((char)this.get8(this.getFileSystemTypeLabelOffset() + i));
        }
        return sb.toString();
    }

    public void setFileSystemTypeLabel(String fsType) throws IllegalArgumentException {
        if (fsType.length() != 8) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < 8; ++i) {
            this.set8(this.getFileSystemTypeLabelOffset() + i, fsType.charAt(i));
        }
    }

    public final long getDataClusterCount() {
        return this.getDataSize() / (long)this.getBytesPerCluster();
    }

    private long getDataSize() {
        return this.getSectorCount() * (long)this.getBytesPerSector() - FatUtils.getFilesOffset(this);
    }

    public String getOemName() {
        int v;
        StringBuilder b = new StringBuilder(8);
        for (int i = 0; i < 8 && (v = this.get8(3 + i)) != 0; ++i) {
            b.append((char)v);
        }
        return b.toString();
    }

    public void setOemName(String name) {
        if (name.length() > 8) {
            throw new IllegalArgumentException("only 8 characters are allowed");
        }
        for (int i = 0; i < 8; ++i) {
            char ch = i < name.length() ? name.charAt(i) : (char)'\u0000';
            this.set8(3 + i, ch);
        }
    }

    public int getBytesPerSector() {
        return this.get16(11);
    }

    public void setBytesPerSector(int v) {
        if (v == this.getBytesPerSector()) {
            return;
        }
        switch (v) {
            case 512: 
            case 1024: 
            case 2048: 
            case 4096: {
                this.set16(11, v);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static boolean isPowerOfTwo(int n) {
        return n != 0 && (n & n - 1) == 0;
    }

    public int getBytesPerCluster() {
        return this.getSectorsPerCluster() * this.getBytesPerSector();
    }

    public int getSectorsPerCluster() {
        return this.get8(13);
    }

    public void setSectorsPerCluster(int v) {
        if (v == this.getSectorsPerCluster()) {
            return;
        }
        if (!BootSector.isPowerOfTwo(v)) {
            throw new IllegalArgumentException("value must be a power of two");
        }
        this.set8(13, v);
    }

    public int getNrReservedSectors() {
        return this.get16(14);
    }

    public void setNrReservedSectors(int v) {
        if (v == this.getNrReservedSectors()) {
            return;
        }
        if (v < 1) {
            throw new IllegalArgumentException("there must be >= 1 reserved sectors");
        }
        this.set16(14, v);
    }

    public final int getNrFats() {
        return this.get8(16);
    }

    public final void setNrFats(int v) {
        if (v == this.getNrFats()) {
            return;
        }
        this.set8(16, v);
    }

    protected int getNrLogicalSectors() {
        return this.get16(19);
    }

    protected void setNrLogicalSectors(int v) {
        if (v == this.getNrLogicalSectors()) {
            return;
        }
        this.set16(19, v);
    }

    protected void setNrTotalSectors(long v) {
        this.set32(32, v);
    }

    protected long getNrTotalSectors() {
        return this.get32(32);
    }

    public int getMediumDescriptor() {
        return this.get8(21);
    }

    public void setMediumDescriptor(int v) {
        this.set8(21, v);
    }

    public int getSectorsPerTrack() {
        return this.get16(24);
    }

    public void setSectorsPerTrack(int v) {
        if (v == this.getSectorsPerTrack()) {
            return;
        }
        this.set16(24, v);
    }

    public int getNrHeads() {
        return this.get16(26);
    }

    public void setNrHeads(int v) {
        if (v == this.getNrHeads()) {
            return;
        }
        this.set16(26, v);
    }

    public long getNrHiddenSectors() {
        return this.get32(28);
    }

    public void setNrHiddenSectors(long v) {
        if (v == this.getNrHiddenSectors()) {
            return;
        }
        this.set32(28, v);
    }

    public String toString() {
        StringBuilder res = new StringBuilder(1024);
        res.append("Bootsector :\n");
        res.append("oemName=");
        res.append(this.getOemName());
        res.append('\n');
        res.append("medium descriptor = ");
        res.append(this.getMediumDescriptor());
        res.append('\n');
        res.append("Nr heads = ");
        res.append(this.getNrHeads());
        res.append('\n');
        res.append("Sectors per track = ");
        res.append(this.getSectorsPerTrack());
        res.append('\n');
        res.append("Sector per cluster = ");
        res.append(this.getSectorsPerCluster());
        res.append('\n');
        res.append("byte per sector = ");
        res.append(this.getBytesPerSector());
        res.append('\n');
        res.append("Nr fats = ");
        res.append(this.getNrFats());
        res.append('\n');
        res.append("Nr hidden sectors = ");
        res.append(this.getNrHiddenSectors());
        res.append('\n');
        res.append("Nr logical sectors = ");
        res.append(this.getNrLogicalSectors());
        res.append('\n');
        res.append("Nr reserved sector = ");
        res.append(this.getNrReservedSectors());
        res.append('\n');
        return res.toString();
    }
}

