/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.ddms.editors;

import com.android.ide.eclipse.base.InstallDetails;
import com.android.uiautomator.UiAutomatorHelper;
import com.android.uiautomator.UiAutomatorModel;
import com.android.uiautomator.UiAutomatorView;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;

public class UiAutomatorViewer
extends EditorPart {
    private String mFilePath;
    private UiAutomatorView mView;

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        return false;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        if (!(iEditorInput instanceof IURIEditorInput)) {
            throw new PartInitException("UI Automator Hierarchy View: unsupported input type.");
        }
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInput(iEditorInput);
        this.mFilePath = ((IURIEditorInput)iEditorInput).getURI().getPath();
        File file = new File(this.mFilePath);
        this.setPartName(file.getName());
    }

    public void createPartControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.mView = new UiAutomatorView(composite2, 2048);
        this.mView.setLayoutData((Object)new GridData(1808));
        if (this.mFilePath == null) {
            return;
        }
        UiAutomatorModel uiAutomatorModel = null;
        File file = new File(this.mFilePath);
        try {
            uiAutomatorModel = new UiAutomatorModel(file);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)composite.getShell(), (String)("Error opening " + this.mFilePath), (String)("Unexpected error while parsing input: " + exception.getMessage()));
            return;
        }
        this.mView.setModel(uiAutomatorModel, file, null);
    }

    public void setFocus() {
    }

    public static boolean openEditor(final UiAutomatorHelper.UiAutomatorResult uiAutomatorResult) {
        final IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(uiAutomatorResult.uiHierarchy.getAbsolutePath()));
        if (!iFileStore.fetchInfo().exists()) {
            return false;
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        final IWorkbench iWorkbench = PlatformUI.getWorkbench();
        iWorkbench.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                if (iWorkbenchWindow == null) {
                    return;
                }
                IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                if (iWorkbenchPage == null) {
                    return;
                }
                if (!iWorkbenchPage.isEditorAreaVisible() && InstallDetails.isAdtInstalled()) {
                    try {
                        iWorkbench.showPerspective("org.eclipse.jdt.ui.JavaPerspective", iWorkbenchWindow);
                    }
                    catch (WorkbenchException workbenchException) {}
                }
                IEditorPart iEditorPart = null;
                try {
                    iEditorPart = IDE.openEditorOnFileStore((IWorkbenchPage)iWorkbenchPage, (IFileStore)iFileStore);
                }
                catch (PartInitException partInitException) {
                    return;
                }
                if (!(iEditorPart instanceof UiAutomatorViewer)) {
                    return;
                }
                ((UiAutomatorViewer)iEditorPart).setModel(uiAutomatorResult.model, uiAutomatorResult.uiHierarchy, uiAutomatorResult.screenshot);
                atomicBoolean.set(true);
            }
        });
        return atomicBoolean.get();
    }

    protected void setModel(UiAutomatorModel uiAutomatorModel, File file, Image image) {
        this.mView.setModel(uiAutomatorModel, file, image);
    }
}

