/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;

public class ToggleButton
extends CLabel {
    private Image[] mImage = new Image[2];
    private String[] mTooltip = new String[2];
    private boolean mMouseIn;
    private int mState = 0;

    public ToggleButton(Composite parent, int style, Image image1, Image image2, String tooltip1, String tooltip2) {
        super(parent, style);
        this.mImage[0] = image1;
        this.mImage[1] = image2;
        this.mTooltip[0] = tooltip1;
        this.mTooltip[1] = tooltip2;
        this.updateImageAndTooltip();
        this.addMouseListener(new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                if (ToggleButton.this.mMouseIn && e.button == 1) {
                    ToggleButton.this.notifyListeners(13, new Event());
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                if (ToggleButton.this.mMouseIn && e.button == 1) {
                    ToggleButton.this.notifyListeners(14, new Event());
                }
            }
        });
        this.addMouseTrackListener(new MouseTrackListener(){

            public void mouseExit(MouseEvent e) {
                if (ToggleButton.this.mMouseIn) {
                    ToggleButton.this.mMouseIn = false;
                    ToggleButton.this.redraw();
                }
            }

            public void mouseEnter(MouseEvent e) {
                if (!ToggleButton.this.mMouseIn) {
                    ToggleButton.this.mMouseIn = true;
                    ToggleButton.this.redraw();
                }
            }

            public void mouseHover(MouseEvent e) {
            }
        });
    }

    public int getStyle() {
        int style = super.getStyle();
        if (this.mMouseIn) {
            style |= 4;
        }
        return style;
    }

    public void setState(int state) {
        assert (state == 0 || state == 1);
        this.mState = state;
        this.updateImageAndTooltip();
        this.redraw();
    }

    public int getState() {
        return this.mState;
    }

    protected void updateImageAndTooltip() {
        this.setImage(this.mImage[this.getState()]);
        this.setToolTipText(this.mTooltip[this.getState()]);
    }
}

