/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state;

import com.android.ide.eclipse.gltrace.state.GLAbstractAtomicProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;

public class GLFloatProperty
extends GLAbstractAtomicProperty {
    private final Float mDefaultValue;
    private Float mCurrentValue;

    public GLFloatProperty(GLStateType gLStateType, Float f) {
        super(gLStateType);
        this.mDefaultValue = this.mCurrentValue = f;
    }

    @Override
    public boolean isDefault() {
        return (double)Math.abs(this.mCurrentValue.floatValue() - this.mDefaultValue.floatValue()) < 1.0E-9;
    }

    public void setValue(Float f) {
        this.mCurrentValue = f;
    }

    @Override
    public void setValue(Object object) {
        if (!(object instanceof Float)) {
            throw new IllegalArgumentException("Attempt to set non float value for " + (Object)((Object)this.getType()));
        }
        this.mCurrentValue = (Float)object;
    }

    @Override
    public Object getValue() {
        return this.mCurrentValue;
    }

    @Override
    public String getStringValue() {
        return this.mCurrentValue.toString();
    }

    public String toString() {
        return (Object)((Object)this.getType()) + "=" + this.getStringValue();
    }
}

