/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.res2.MergingException;
import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergeType;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.OrphanXmlElement;
import com.android.manifmerger.OtherOperationType;
import com.android.manifmerger.Selector;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.utils.ILogger;
import com.android.utils.PositionXmlParser;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlElement
extends OrphanXmlElement {
    @NonNull
    private final XmlDocument mDocument;
    private final NodeOperationType mNodeOperationType;
    private final ImmutableList<XmlAttribute> mAttributes;
    private final Map<XmlNode.NodeName, AttributeOperationType> mAttributesOperationTypes;
    private final ImmutableList<XmlElement> mMergeableChildren;
    @Nullable
    private final Selector mSelector;

    public XmlElement(@NonNull Element xml, @NonNull XmlDocument document) {
        super(xml);
        Node attribute;
        int i;
        this.mDocument = Preconditions.checkNotNull(document);
        Selector selector = null;
        ImmutableMap.Builder<XmlNode.NodeName, AttributeOperationType> attributeOperationTypeBuilder = ImmutableMap.builder();
        ImmutableList.Builder attributesListBuilder = ImmutableList.builder();
        NamedNodeMap namedNodeMap = this.getXml().getAttributes();
        NodeOperationType lastNodeOperationType = null;
        for (i = 0; i < namedNodeMap.getLength(); ++i) {
            AttributeOperationType attributeOperationType;
            attribute = namedNodeMap.item(i);
            if (!"http://schemas.android.com/tools".equals(attribute.getNamespaceURI())) continue;
            String instruction = attribute.getLocalName();
            if (instruction.equals("node")) {
                lastNodeOperationType = NodeOperationType.valueOf(SdkUtils.camelCaseToConstantName(attribute.getNodeValue()));
                continue;
            }
            if (instruction.equals("selector")) {
                selector = new Selector(attribute.getNodeValue());
                continue;
            }
            try {
                attributeOperationType = AttributeOperationType.valueOf(SdkUtils.xmlNameToConstantName(instruction));
            }
            catch (IllegalArgumentException e) {
                try {
                    OtherOperationType.valueOf(instruction);
                    break;
                }
                catch (IllegalArgumentException e1) {
                    String errorMessage = String.format("[%1$s:%2$s] Invalid instruction '%3$s', valid instructions are : %4$s", this.mDocument.getSourceLocation().print(false), this.mDocument.getNodePosition(xml).getLine(), instruction, Joiner.on(',').join((Object[])AttributeOperationType.values()));
                    throw new RuntimeException(new MergingException(errorMessage, e));
                }
            }
            for (String attributeName : Splitter.on(',').trimResults().split(attribute.getNodeValue())) {
                if (attributeName.indexOf(58) == -1) {
                    String toolsPrefix = XmlUtils.lookupNamespacePrefix(this.getXml(), "http://schemas.android.com/tools", "android", false);
                    attributeName = toolsPrefix + ':' + attributeName;
                }
                XmlNode.NodeName nodeName = XmlNode.fromXmlName(attributeName);
                attributeOperationTypeBuilder.put(nodeName, attributeOperationType);
            }
        }
        this.mAttributesOperationTypes = attributeOperationTypeBuilder.build();
        for (i = 0; i < namedNodeMap.getLength(); ++i) {
            attribute = namedNodeMap.item(i);
            XmlAttribute xmlAttribute = new XmlAttribute(this, (Attr)attribute, this.getType().getAttributeModel(XmlNode.fromXmlName(((Attr)attribute).getName())));
            attributesListBuilder.add(xmlAttribute);
        }
        this.mNodeOperationType = lastNodeOperationType;
        this.mAttributes = attributesListBuilder.build();
        this.mMergeableChildren = this.initMergeableChildren();
        this.mSelector = selector;
    }

    @NonNull
    public XmlDocument getDocument() {
        return this.mDocument;
    }

    public List<XmlAttribute> getAttributes() {
        return this.mAttributes;
    }

    public Optional<XmlAttribute> getAttribute(XmlNode.NodeName attributeName) {
        for (XmlAttribute xmlAttribute : this.mAttributes) {
            if (!xmlAttribute.getName().equals(attributeName)) continue;
            return Optional.of(xmlAttribute);
        }
        return Optional.absent();
    }

    public NodeOperationType getOperationType() {
        return this.mNodeOperationType != null ? this.mNodeOperationType : NodeOperationType.MERGE;
    }

    public AttributeOperationType getAttributeOperationType(XmlNode.NodeName attributeName) {
        return this.mAttributesOperationTypes.containsKey(attributeName) ? this.mAttributesOperationTypes.get(attributeName) : AttributeOperationType.STRICT;
    }

    public Collection<Map.Entry<XmlNode.NodeName, AttributeOperationType>> getAttributeOperations() {
        return this.mAttributesOperationTypes.entrySet();
    }

    @Override
    @NonNull
    public PositionXmlParser.Position getPosition() {
        return this.mDocument.getNodePosition(this);
    }

    @Override
    @NonNull
    public XmlLoader.SourceLocation getSourceLocation() {
        return this.getDocument().getSourceLocation();
    }

    public void mergeWithLowerPriorityNode(XmlElement lowerPriorityNode, MergingReport.Builder mergingReport) {
        if (this.mSelector != null && !this.mSelector.isResolvable(this.getDocument().getSelectors())) {
            mergingReport.addMessage(this.getSourceLocation(), this.getLine(), this.getColumn(), MergingReport.Record.Severity.ERROR, String.format("'tools:selector=\"%1$s\"' is not a valid library identifier, valid identifiers are : %2$s", this.mSelector.toString(), Joiner.on(',').join(this.mDocument.getSelectors().getKeys())));
            return;
        }
        mergingReport.getLogger().info("Merging " + this.getId() + " with lower " + lowerPriorityNode.printPosition(), new Object[0]);
        MergeType mergeType = this.getType().getMergeType();
        if (this.isA(ManifestModel.NodeTypes.MANIFEST) && this.getDocument().getFileType() == XmlDocument.Type.OVERLAY) {
            mergeType = MergeType.MERGE;
        }
        if (mergeType != MergeType.MERGE_CHILDREN_ONLY) {
            ArrayList<AttributeModel> attributeModels = new ArrayList<AttributeModel>(lowerPriorityNode.getType().getAttributeModels());
            for (XmlAttribute lowerPriorityAttribute : lowerPriorityNode.getAttributes()) {
                lowerPriorityAttribute.mergeInHigherPriorityElement(this, mergingReport);
                if (lowerPriorityAttribute.getModel() == null) continue;
                attributeModels.remove(lowerPriorityAttribute.getModel());
            }
            for (AttributeModel attributeModel : attributeModels) {
                Optional<XmlAttribute> myAttribute;
                if (attributeModel.getDefaultValue() == null || !(myAttribute = this.getAttribute(attributeModel.getName())).isPresent()) continue;
                myAttribute.get().mergeWithLowerPriorityDefaultValue(mergingReport, lowerPriorityNode);
            }
        }
        if (this.mNodeOperationType != NodeOperationType.MERGE_ONLY_ATTRIBUTES) {
            this.mergeChildren(lowerPriorityNode, mergingReport);
        } else {
            for (XmlElement lowerPriorityChild : lowerPriorityNode.getMergeableElements()) {
                mergingReport.getActionRecorder().recordNodeAction(this, Actions.ActionType.REJECTED, lowerPriorityChild);
            }
        }
    }

    public ImmutableList<XmlElement> getMergeableElements() {
        return this.mMergeableChildren;
    }

    public Optional<XmlElement> getNodeByTypeAndKey(ManifestModel.NodeTypes type, @Nullable String keyValue) {
        for (XmlElement xmlElement : this.mMergeableChildren) {
            if (!xmlElement.isA(type) || keyValue != null && !keyValue.equals(xmlElement.getKey())) continue;
            return Optional.of(xmlElement);
        }
        return Optional.absent();
    }

    public ImmutableList<XmlElement> getAllNodesByType(ManifestModel.NodeTypes type) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (XmlElement mergeableChild : this.initMergeableChildren()) {
            if (!mergeableChild.isA(type)) continue;
            listBuilder.add(mergeableChild);
        }
        return listBuilder.build();
    }

    public void mergeChildren(XmlElement lowerPriorityNode, MergingReport.Builder mergingReport) {
        for (XmlElement lowerPriorityChild : lowerPriorityNode.getMergeableElements()) {
            if (this.shouldIgnore(lowerPriorityChild, mergingReport)) continue;
            this.mergeChild(lowerPriorityChild, mergingReport);
        }
    }

    private void mergeChild(XmlElement lowerPriorityChild, MergingReport.Builder mergingReport) {
        ILogger logger = mergingReport.getLogger();
        if (lowerPriorityChild.getType() == ManifestModel.NodeTypes.CUSTOM) {
            this.handleCustomElement(lowerPriorityChild, mergingReport);
            return;
        }
        Optional<XmlElement> thisChildOptional = this.getNodeByTypeAndKey(lowerPriorityChild.getType(), lowerPriorityChild.getKey());
        if (!thisChildOptional.isPresent()) {
            this.addElement(lowerPriorityChild, mergingReport);
            return;
        }
        logger.verbose(lowerPriorityChild.getId() + " defined in both files...", new Object[0]);
        XmlElement thisChild = thisChildOptional.get();
        switch (thisChild.getType().getMergeType()) {
            case CONFLICT: {
                this.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Node %1$s cannot be present in more than one input file and it's present at %2$s and %3$s", new Object[]{thisChild.getType(), thisChild.printPosition(), lowerPriorityChild.printPosition()}));
                break;
            }
            case ALWAYS: {
                NodeOperationType operationType = XmlElement.calculateNodeOperationType(thisChild, lowerPriorityChild);
                if (operationType == NodeOperationType.REMOVE || operationType == NodeOperationType.REPLACE) {
                    mergingReport.getActionRecorder().recordNodeAction(thisChild, Actions.ActionType.REJECTED, lowerPriorityChild);
                    break;
                }
                if (thisChild.getType().areMultipleDeclarationAllowed()) {
                    this.mergeChildrenWithMultipleDeclarations(lowerPriorityChild, mergingReport);
                    break;
                }
                if (thisChild.isEquals(lowerPriorityChild)) break;
                this.addElement(lowerPriorityChild, mergingReport);
                break;
            }
            default: {
                this.handleTwoElementsExistence(thisChild, lowerPriorityChild, mergingReport);
            }
        }
    }

    private void handleCustomElement(XmlElement customElement, MergingReport.Builder mergingReport) {
        this.addElement(customElement, mergingReport);
        String nodeName = customElement.getXml().getNodeName();
        if (!nodeName.contains(":")) {
            return;
        }
        String prefix = nodeName.substring(0, nodeName.indexOf(58));
        String namespace = customElement.getDocument().getRootNode().getXml().getAttribute("xmlns:" + prefix);
        if (namespace != null) {
            this.getDocument().getRootNode().getXml().setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, namespace);
        }
    }

    private void mergeChildrenWithMultipleDeclarations(XmlElement lowerPriorityChild, MergingReport.Builder mergingReport) {
        Preconditions.checkArgument(lowerPriorityChild.getType().areMultipleDeclarationAllowed());
        if (lowerPriorityChild.getType().areMultipleDeclarationAllowed()) {
            for (XmlElement sameTypeChild : this.getAllNodesByType(lowerPriorityChild.getType())) {
                if (!sameTypeChild.getId().equals(lowerPriorityChild.getId()) || !sameTypeChild.isEquals(lowerPriorityChild)) continue;
                return;
            }
        }
        this.addElement(lowerPriorityChild, mergingReport);
    }

    private boolean shouldIgnore(XmlElement lowerPriorityChild, MergingReport.Builder mergingReport) {
        boolean shouldDelete;
        if (lowerPriorityChild.getType().getMergeType() == MergeType.IGNORE) {
            return true;
        }
        Optional<XmlElement> thisChildElementOptional = this.getNodeByTypeAndKey(lowerPriorityChild.getType(), null);
        if (!thisChildElementOptional.isPresent()) {
            return false;
        }
        XmlElement thisChild = thisChildElementOptional.get();
        boolean bl = shouldDelete = thisChild.mNodeOperationType == NodeOperationType.REMOVE_ALL && (thisChild.mSelector == null || thisChild.mSelector.appliesTo(lowerPriorityChild));
        if (shouldDelete) {
            mergingReport.getActionRecorder().recordNodeAction(thisChildElementOptional.get(), Actions.ActionType.REJECTED, lowerPriorityChild);
        }
        return shouldDelete;
    }

    private void handleTwoElementsExistence(XmlElement higherPriority, XmlElement lowerPriority, MergingReport.Builder mergingReport) {
        NodeOperationType operationType = XmlElement.calculateNodeOperationType(higherPriority, lowerPriority);
        switch (operationType) {
            case MERGE: 
            case MERGE_ONLY_ATTRIBUTES: {
                mergingReport.getActionRecorder().recordNodeAction(higherPriority, Actions.ActionType.MERGED, lowerPriority);
                higherPriority.mergeWithLowerPriorityNode(lowerPriority, mergingReport);
                break;
            }
            case REMOVE: 
            case REPLACE: {
                mergingReport.getActionRecorder().recordNodeAction(higherPriority, Actions.ActionType.REJECTED, lowerPriority);
                break;
            }
            case STRICT: {
                Optional<String> compareMessage = higherPriority.compareTo(lowerPriority);
                if (!compareMessage.isPresent()) break;
                this.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, String.format("Node %1$s at %2$s is tagged with tools:node=\"strict\", yet %3$s at %4$s is different : %5$s", higherPriority.getId(), higherPriority.printPosition(), lowerPriority.getId(), lowerPriority.printPosition(), compareMessage.get()));
                break;
            }
            default: {
                mergingReport.getLogger().error(null, "Unhandled node operation type %s", higherPriority.getOperationType());
            }
        }
    }

    private static NodeOperationType calculateNodeOperationType(@NonNull XmlElement higherPriority, @NonNull XmlElement lowerPriority) {
        NodeOperationType operationType = higherPriority.getOperationType();
        if (operationType.isSelectable() && higherPriority.mSelector != null && !higherPriority.mSelector.appliesTo(lowerPriority)) {
            operationType = NodeOperationType.MERGE;
        }
        return operationType;
    }

    private void addElement(XmlElement elementToBeAdded, MergingReport.Builder mergingReport) {
        List<Node> comments = XmlElement.getLeadingComments(elementToBeAdded.getXml());
        mergingReport.getActionRecorder().recordDefaultNodeAction(elementToBeAdded);
        Node node = this.getXml().getOwnerDocument().adoptNode(elementToBeAdded.getXml());
        this.getXml().appendChild(node);
        for (Node comment : comments) {
            Node newComment = this.getXml().getOwnerDocument().adoptNode(comment);
            this.getXml().insertBefore(newComment, node);
        }
        mergingReport.getLogger().verbose("Adopted " + node, new Object[0]);
    }

    public boolean isEquals(XmlElement otherNode) {
        return !this.compareTo(otherNode).isPresent();
    }

    public Optional<String> compareTo(Object other) {
        Optional<String> message;
        if (!(other instanceof XmlElement)) {
            return Optional.of("Wrong type");
        }
        XmlElement otherNode = (XmlElement)other;
        if (this.getXml().getNamespaceURI() != null) {
            if (!this.getXml().getLocalName().equals(otherNode.getXml().getLocalName())) {
                return Optional.of(String.format("Element names do not match: %1$s versus %2$s", this.getXml().getLocalName(), otherNode.getXml().getLocalName()));
            }
            String thisNS = this.getXml().getNamespaceURI();
            String otherNS = otherNode.getXml().getNamespaceURI();
            if (thisNS == null && otherNS != null || thisNS != null && !thisNS.equals(otherNS)) {
                return Optional.of(String.format("Element namespaces names do not match: %1$s versus %2$s", thisNS, otherNS));
            }
        } else if (!this.getXml().getNodeName().equals(otherNode.getXml().getNodeName())) {
            return Optional.of(String.format("Element names do not match: %1$s versus %2$s", this.getXml().getNodeName(), otherNode.getXml().getNodeName()));
        }
        if ((message = XmlElement.checkAttributes(this, otherNode)).isPresent()) {
            return message;
        }
        message = XmlElement.checkAttributes(otherNode, this);
        if (message.isPresent()) {
            return message;
        }
        List<Node> expectedChildren = XmlElement.filterUninterestingNodes(this.getXml().getChildNodes());
        List<Node> actualChildren = XmlElement.filterUninterestingNodes(otherNode.getXml().getChildNodes());
        if (expectedChildren.size() != actualChildren.size()) {
            if (expectedChildren.size() > actualChildren.size()) {
                List missingChildrenNames = Lists.transform(expectedChildren, NODE_TO_NAME);
                missingChildrenNames.removeAll(Lists.transform(actualChildren, NODE_TO_NAME));
                return Optional.of(String.format("%1$s: Number of children do not match up: expected %2$d versus %3$d at %4$s, missing %5$s", this.getId(), expectedChildren.size(), actualChildren.size(), otherNode.printPosition(), Joiner.on(",").join(missingChildrenNames)));
            }
            List extraChildrenNames = Lists.transform(actualChildren, NODE_TO_NAME);
            extraChildrenNames.removeAll(Lists.transform(expectedChildren, NODE_TO_NAME));
            return Optional.of(String.format("%1$s: Number of children do not match up: expected %2$d versus %3$d at %4$s, extra elements found : %5$s", this.getId(), expectedChildren.size(), actualChildren.size(), otherNode.printPosition(), Joiner.on(",").join(expectedChildren)));
        }
        for (Node expectedChild : expectedChildren) {
            XmlElement expectedChildNode;
            if (expectedChild.getNodeType() != 1 || !(message = this.findAndCompareNode(otherNode, actualChildren, expectedChildNode = new XmlElement((Element)expectedChild, this.mDocument))).isPresent()) continue;
            return message;
        }
        return Optional.absent();
    }

    private Optional<String> findAndCompareNode(XmlElement otherElement, List<Node> otherElementChildren, XmlElement childNode) {
        for (Node potentialNode : otherElementChildren) {
            if (potentialNode.getNodeType() != 1) continue;
            XmlElement otherChildNode = new XmlElement((Element)potentialNode, this.mDocument);
            if (childNode.getType() != otherChildNode.getType()) continue;
            if (childNode.getType().getNodeKeyResolver().getKeyAttributesNames().isEmpty()) {
                if (childNode.compareTo(otherChildNode).isPresent()) continue;
                return Optional.absent();
            }
            if (!(childNode.getKey() == null ? otherChildNode.getKey() == null : childNode.getKey().equals(otherChildNode.getKey()))) continue;
            return childNode.compareTo(otherChildNode);
        }
        return Optional.of(String.format("Child %1$s not found in document %2$s", childNode.getId(), otherElement.printPosition()));
    }

    private static List<Node> filterUninterestingNodes(NodeList nodeList) {
        ArrayList<Node> interestingNodes = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                Text t = (Text)node;
                if (t.getData().trim().isEmpty()) continue;
                interestingNodes.add(node);
                continue;
            }
            if (node.getNodeType() == 8) continue;
            interestingNodes.add(node);
        }
        return interestingNodes;
    }

    private static Optional<String> checkAttributes(XmlElement expected, XmlElement actual) {
        for (XmlAttribute expectedAttr : expected.getAttributes()) {
            XmlNode.NodeName attributeName = expectedAttr.getName();
            if (attributeName.isInNamespace("http://schemas.android.com/tools")) continue;
            Optional<XmlAttribute> actualAttr = actual.getAttribute(attributeName);
            if (actualAttr.isPresent()) {
                if (expectedAttr.getValue().equals(actualAttr.get().getValue())) continue;
                return Optional.of(String.format("Attribute %1$s do not match: %2$s versus %3$s at %4$s", expectedAttr.getId(), expectedAttr.getValue(), actualAttr.get().getValue(), actual.printPosition()));
            }
            return Optional.of(String.format("Attribute %1$s not found at %2$s", expectedAttr.getId(), actual.printPosition()));
        }
        return Optional.absent();
    }

    private ImmutableList<XmlElement> initMergeableChildren() {
        ImmutableList.Builder mergeableNodes = new ImmutableList.Builder();
        NodeList nodeList = this.getXml().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            XmlElement xmlElement = new XmlElement((Element)node, this.mDocument);
            mergeableNodes.add(xmlElement);
        }
        return mergeableNodes.build();
    }

    static List<Node> getLeadingComments(Node nodeToBeAdopted) {
        ImmutableList.Builder nodesToAdopt = new ImmutableList.Builder();
        for (Node previousSibling = nodeToBeAdopted.getPreviousSibling(); previousSibling != null && (previousSibling.getNodeType() == 8 || previousSibling.getNodeType() == 3); previousSibling = previousSibling.getPreviousSibling()) {
            if (previousSibling.getNodeType() != 8) continue;
            nodesToAdopt.add(previousSibling);
        }
        return ((ImmutableList)nodesToAdopt.build()).reverse();
    }

    void addMessage(MergingReport.Builder mergingReport, MergingReport.Record.Severity severity, String message) {
        mergingReport.addMessage(this.getDocument().getSourceLocation(), this.getLine(), this.getColumn(), severity, message);
    }
}

