/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.interpreter;

import com.google.clearsilver.jsilver.autoescape.EscapeMode;
import com.google.clearsilver.jsilver.exceptions.JSilverIOException;
import com.google.clearsilver.jsilver.interpreter.TemplateFactory;
import com.google.clearsilver.jsilver.resourceloader.ResourceLoader;
import com.google.clearsilver.jsilver.syntax.SyntaxTreeBuilder;
import com.google.clearsilver.jsilver.syntax.TemplateSyntaxTree;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class LoadingTemplateFactory
implements TemplateFactory {
    private final SyntaxTreeBuilder syntaxTreeBuilder = new SyntaxTreeBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemplateSyntaxTree find(String templateName, ResourceLoader resourceLoader, EscapeMode escapeMode) {
        TemplateSyntaxTree templateSyntaxTree;
        Reader reader = resourceLoader.openOrFail(templateName);
        try {
            templateSyntaxTree = this.syntaxTreeBuilder.parse(reader, templateName, escapeMode);
        }
        catch (Throwable throwable) {
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new JSilverIOException(e);
            }
        }
        reader.close();
        return templateSyntaxTree;
    }

    public TemplateSyntaxTree createTemp(String content, EscapeMode escapeMode) {
        return this.syntaxTreeBuilder.parse(new StringReader(content), "", escapeMode);
    }
}

