/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.GLEnum;
import com.android.ide.eclipse.gltrace.state.GLIntegerProperty;
import com.android.ide.eclipse.gltrace.state.GLStateType;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.GLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;

public class CurrentVboPropertyAccessor
implements IGLPropertyAccessor {
    private final int mContextId;
    private final IGLPropertyAccessor mVboBindingAccessor;
    private final GLStateType mVboProperty;

    public CurrentVboPropertyAccessor(int contextId, GLEnum target, GLStateType vboProperty) {
        this.mContextId = contextId;
        this.mVboProperty = vboProperty;
        GLStateType vboType = target == GLEnum.GL_ARRAY_BUFFER ? GLStateType.ARRAY_BUFFER_BINDING : GLStateType.ELEMENT_ARRAY_BUFFER_BINDING;
        this.mVboBindingAccessor = GLPropertyAccessor.makeAccessor(contextId, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.BUFFER_BINDINGS, vboType});
    }

    @Override
    public IGLProperty getProperty(IGLProperty state) {
        IGLProperty currentBinding = this.mVboBindingAccessor.getProperty(state);
        if (!(currentBinding instanceof GLIntegerProperty)) {
            return null;
        }
        Integer buffer = (Integer)currentBinding.getValue();
        return GLPropertyAccessor.makeAccessor(this.mContextId, new Object[]{GLStateType.VERTEX_ARRAY_DATA, GLStateType.VBO, buffer, this.mVboProperty}).getProperty(state);
    }

    @Override
    public String getPath() {
        return String.format("VERTEX_ARRAY_DATA/VBO/${currentBuffer}/%s", new Object[]{this.mVboProperty});
    }
}

