/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.gltrace.state.transforms;

import com.android.ide.eclipse.gltrace.state.GLSparseArrayProperty;
import com.android.ide.eclipse.gltrace.state.IGLProperty;
import com.android.ide.eclipse.gltrace.state.transforms.IGLPropertyAccessor;
import com.android.ide.eclipse.gltrace.state.transforms.IStateTransform;

public class SparseArrayElementAddTransform
implements IStateTransform {
    private IGLPropertyAccessor mAccessor;
    private int mKey;
    private IGLProperty mOldValue;

    public SparseArrayElementAddTransform(IGLPropertyAccessor accessor, int key) {
        this.mAccessor = accessor;
        this.mKey = key;
    }

    @Override
    public void apply(IGLProperty currentState) {
        GLSparseArrayProperty propertyArray = this.getArray(currentState);
        if (propertyArray != null) {
            this.mOldValue = propertyArray.getProperty(this.mKey);
            if (this.mOldValue == null) {
                propertyArray.add(this.mKey);
            }
        }
    }

    @Override
    public void revert(IGLProperty currentState) {
        GLSparseArrayProperty propertyArray = this.getArray(currentState);
        if (propertyArray != null && this.mOldValue == null) {
            propertyArray.delete(this.mKey);
        }
    }

    @Override
    public IGLProperty getChangedProperty(IGLProperty currentState) {
        return this.getArray(currentState);
    }

    private GLSparseArrayProperty getArray(IGLProperty state) {
        IGLProperty p = state;
        if (this.mAccessor != null) {
            p = this.mAccessor.getProperty(p);
        }
        if (p instanceof GLSparseArrayProperty) {
            return (GLSparseArrayProperty)p;
        }
        return null;
    }
}

