/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.annotations.NonNull;
import com.android.sdklib.internal.repository.AdbWrapper;
import com.android.sdklib.internal.repository.ITaskMonitor;
import com.android.sdklib.internal.repository.NullTaskMonitor;
import com.android.sdklib.internal.repository.archives.Archive;
import com.android.sdklib.internal.repository.updater.ArchiveInfo;
import com.android.sdklib.internal.repository.updater.SdkUpdaterLogic;
import com.android.sdklib.internal.repository.updater.UpdaterData;
import com.android.sdkuilib.internal.repository.SdkUpdaterChooserDialog;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.utils.ILogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SwtUpdaterData
extends UpdaterData {
    private Shell mWindowShell;
    private ImageFactory mImageFactory;

    public SwtUpdaterData(String osSdkRoot, ILogger sdkLog) {
        super(osSdkRoot, sdkLog);
    }

    public void setImageFactory(ImageFactory imageFactory) {
        this.mImageFactory = imageFactory;
    }

    public ImageFactory getImageFactory() {
        return this.mImageFactory;
    }

    public void setWindowShell(Shell windowShell) {
        this.mWindowShell = windowShell;
    }

    public Shell getWindowShell() {
        return this.mWindowShell;
    }

    @Override
    protected void displayInitError(String error) {
        if (this.mWindowShell != null && !this.mWindowShell.isDisposed()) {
            MessageDialog.openError(this.mWindowShell, "Android Virtual Devices Manager", error);
        } else {
            super.displayInitError(error);
        }
    }

    @Override
    protected void runOnUiThread(@NonNull Runnable r) {
        if (this.mWindowShell != null && !this.mWindowShell.isDisposed()) {
            this.mWindowShell.getDisplay().syncExec(r);
        }
    }

    @Override
    protected void askForAdbRestart(ITaskMonitor monitor) {
        Shell shell;
        final boolean[] canRestart = new boolean[]{true};
        if (this.getWindowShell() != null && this.getSettingsController().getSettings().getAskBeforeAdbRestart() && (shell = this.getWindowShell()) != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!shell.isDisposed()) {
                        canRestart[0] = MessageDialog.openQuestion(shell, "ADB Restart", "A package that depends on ADB has been updated. \nDo you want to restart ADB now?");
                    }
                }
            });
        }
        if (canRestart[0]) {
            AdbWrapper adb = new AdbWrapper(this.getOsSdkRoot(), monitor);
            adb.stopAdb();
            adb.startAdb();
        }
    }

    @Override
    protected void notifyToolsNeedsToBeRestarted(int flags) {
        String msg = null;
        if ((flags & 1) != 0) {
            msg = "The Android SDK and AVD Manager that you are currently using has been updated. Please also run Eclipse > Help > Check for Updates to see if the Android plug-in needs to be updated.";
        } else if ((flags & 2) != 0) {
            msg = "The Android SDK and AVD Manager that you are currently using has been updated. It is recommended that you now close the manager window and re-open it. If you use Eclipse, please run Help > Check for Updates to see if the Android plug-in needs to be updated.";
        }
        final String msg2 = msg;
        final Shell shell = this.getWindowShell();
        if (msg2 != null && shell != null && !shell.isDisposed()) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!shell.isDisposed()) {
                        MessageDialog.openInformation(shell, "Android Tools Updated", msg2);
                    }
                }
            });
        }
    }

    @Override
    public List<Archive> updateOrInstallAll_WithGUI(Collection<Archive> selectedArchives, boolean includeObsoletes, int flags) {
        SdkUpdaterLogic ul = new SdkUpdaterLogic(this);
        List<ArchiveInfo> archives = ul.computeUpdates(selectedArchives, this.getSources(), this.getLocalSdkParser().getPackages(), includeObsoletes);
        if (selectedArchives == null) {
            this.getPackageLoader().loadRemoteAddonsList(new NullTaskMonitor(this.getSdkLog()));
            ul.addNewPlatforms(archives, this.getSources(), this.getLocalSdkParser().getPackages(), includeObsoletes);
        }
        Collections.sort(archives);
        SdkUpdaterChooserDialog dialog = new SdkUpdaterChooserDialog(this.getWindowShell(), this, archives);
        dialog.open();
        ArrayList<ArchiveInfo> result = dialog.getResult();
        if (result != null && result.size() > 0) {
            return this.installArchives(result, flags);
        }
        return null;
    }
}

