/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Attr;

public class SignatureOrSystemDetector
extends Detector
implements Detector.XmlScanner {
    public static final Issue ISSUE = Issue.create("SignatureOrSystemPermissions", "signatureOrSystem permissions declared", "Checks for signatureOrSystem level permissions", "The `signature` protection level should probably be sufficient for most needs and works regardless of where applications are installed. The `signatureOrSystem` level is used for certain situations where multiple vendors have applications built into a system image and need to share specific features explicitly because they are being built together.", Category.SECURITY, 5, Severity.WARNING, new Implementation(SignatureOrSystemDetector.class, Scope.MANIFEST_SCOPE));
    private static final String SIGNATURE_OR_SYSTEM = "signatureOrSystem";
    private static final String PROTECTION_LEVEL = "protectionLevel";

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList(PROTECTION_LEVEL);
    }

    @Override
    public void visitAttribute(@NonNull XmlContext context, @NonNull Attr attribute) {
        String protectionLevel = attribute.getValue();
        if (protectionLevel != null && protectionLevel.equals(SIGNATURE_OR_SYSTEM)) {
            String message = "protectionLevel should probably not be set to signatureOrSystem";
            context.report(ISSUE, attribute, context.getLocation(attribute), message, null);
        }
    }
}

