/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.internal.repository.packages.IFullRevisionProvider;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public abstract class FullRevisionPackage
extends Package
implements IFullRevisionProvider {
    private final FullRevision mPreviewVersion;

    FullRevisionPackage(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        this.mPreviewVersion = PackageParserUtils.parseFullRevisionElement(PackageParserUtils.findChildElement(packageNode, "revision"));
    }

    public FullRevisionPackage(SdkSource source, Properties props, int revision, String license, String description, String descUrl, String archiveOsPath) {
        super(source, props, revision, license, description, descUrl, archiveOsPath);
        FullRevision rev = PackageParserUtils.getPropertyFull(props, "Pkg.Revision");
        if (rev == null) {
            rev = new FullRevision(revision);
        }
        this.mPreviewVersion = rev;
    }

    @Override
    public FullRevision getRevision() {
        return this.mPreviewVersion;
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        props.setProperty("Pkg.Revision", this.mPreviewVersion.toShortString());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.mPreviewVersion == null ? 0 : this.mPreviewVersion.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FullRevisionPackage)) {
            return false;
        }
        FullRevisionPackage other = (FullRevisionPackage)obj;
        return !(this.mPreviewVersion == null ? other.mPreviewVersion != null : !this.mPreviewVersion.equals(other.mPreviewVersion));
    }

    @Override
    public Package.UpdateInfo canBeUpdatedBy(Package replacementPackage) {
        if (replacementPackage == null) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (!this.sameItemAs(replacementPackage, FullRevision.PreviewComparison.IGNORE)) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (!this.getRevision().isPreview() && replacementPackage.getRevision().isPreview()) {
            return Package.UpdateInfo.INCOMPATIBLE;
        }
        if (replacementPackage.getRevision().compareTo(this.getRevision()) > 0) {
            return Package.UpdateInfo.UPDATE;
        }
        return Package.UpdateInfo.NOT_UPDATE;
    }
}

