/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.dom.properties.converters;

import org.eclipse.e4.ui.css.core.dom.properties.converters.AbstractCSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverter;
import org.eclipse.e4.ui.css.core.dom.properties.converters.ICSSValueConverterConfig;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;

public class CSSValueBooleanConverterImpl
extends AbstractCSSValueConverter {
    public static final ICSSValueConverter INSTANCE = new CSSValueBooleanConverterImpl();

    public CSSValueBooleanConverterImpl() {
        super(Boolean.class);
    }

    public Object convert(CSSValue value, CSSEngine engine, Object context) throws Exception {
        CSSPrimitiveValue primitiveValue;
        if (value.getCssValueType() == 1 && "true".equals((primitiveValue = (CSSPrimitiveValue)value).getStringValue())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String convert(Object value, CSSEngine engine, Object context, ICSSValueConverterConfig config) throws Exception {
        Boolean b;
        if (value instanceof Boolean && (b = (Boolean)value).booleanValue()) {
            return "true";
        }
        return "false";
    }
}

