/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.resources;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.ui.css.core.resources.IResourcesRegistry;

public abstract class AbstractResourcesRegistry
implements IResourcesRegistry {
    private Map allResourcesMap = null;

    public Object getResource(Object type, Object key) {
        if (this.allResourcesMap == null) {
            return null;
        }
        Map resourcesMap = (Map)this.allResourcesMap.get(type);
        if (resourcesMap == null) {
            return null;
        }
        return resourcesMap.get(key);
    }

    public void registerResource(Object type, Object key, Object resource) {
        HashMap<Object, Object> resourcesMap;
        if (this.allResourcesMap == null) {
            this.allResourcesMap = new HashMap();
        }
        if ((resourcesMap = (HashMap<Object, Object>)this.allResourcesMap.get(type)) == null) {
            resourcesMap = new HashMap<Object, Object>();
            this.allResourcesMap.put(type, resourcesMap);
        }
        resourcesMap.put(key, resource);
    }

    public void unregisterResource(Object type, Object key) {
        if (this.allResourcesMap == null) {
            return;
        }
        Map resourcesMap = (Map)this.allResourcesMap.get(type);
        if (resourcesMap == null) {
            return;
        }
        Object resource = resourcesMap.get(key);
        if (resource != null) {
            resourcesMap.remove(resource);
        }
    }

    public void unregisterResource(Object resource) {
        Map resourcesMap;
        Object type = this.getResourceType(resource);
        if (type != null && (resourcesMap = (Map)this.allResourcesMap.get(type)) != null) {
            resourcesMap.remove(resource);
        }
    }

    public Object getResourceType(Object resource) {
        return resource.getClass();
    }

    public void dispose() {
        if (this.allResourcesMap == null) {
            return;
        }
        Set allResources = this.allResourcesMap.entrySet();
        for (Map.Entry entry : allResources) {
            Object type = entry.getKey();
            Map resourcesMap = (Map)entry.getValue();
            Set resources = resourcesMap.entrySet();
            for (Map.Entry entry2 : resources) {
                this.disposeResource(type, (String)entry2.getKey(), entry2.getValue());
            }
        }
        this.allResourcesMap = null;
    }

    public abstract void disposeResource(Object var1, String var2, Object var3);
}

