/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.xml;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public enum XmlFormatStyle {
    LAYOUT,
    FILE,
    RESOURCE,
    MANIFEST;


    @NonNull
    public static XmlFormatStyle get(@Nullable Node node) {
        if (node != null) {
            Element root;
            Document doc;
            Document document = doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
            if (doc != null && (root = doc.getDocumentElement()) != null) {
                String tag = root.getTagName();
                if (tag.equals("resources")) {
                    return RESOURCE;
                }
                if (tag.equals("manifest")) {
                    return MANIFEST;
                }
                if (Character.isUpperCase(tag.charAt(0)) || "view".equals(tag) || "include".equals(tag) || "merge".equals(tag) || tag.indexOf(46) != -1) {
                    return LAYOUT;
                }
            }
        }
        return FILE;
    }
}

