/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkstats;

import com.android.sdkstats.DdmsPreferenceStore;
import com.android.sdkstats.SdkStatsPermissionDialog;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SdkStatsService {
    protected static final String SYS_PROP_OS_ARCH = "os.arch";
    protected static final String SYS_PROP_JAVA_VERSION = "java.version";
    protected static final String SYS_PROP_OS_VERSION = "os.version";
    protected static final String SYS_PROP_OS_NAME = "os.name";
    private static final long PING_INTERVAL_MSEC = 86400000L;
    private static final boolean DEBUG = System.getenv("ANDROID_DEBUG_PING") != null;
    private DdmsPreferenceStore mStore = new DdmsPreferenceStore();

    public void ping(String app, String version) {
        this.doPing(app, version, null);
    }

    public void ping(String[] arguments) {
        if (arguments == null || arguments.length < 3) {
            throw new IllegalArgumentException("Invalid ping arguments: expected ['ping', app, version] but got " + (arguments == null ? "null" : Arrays.toString(arguments)));
        }
        int len = arguments.length;
        String app = arguments[1];
        String version = arguments[2];
        HashMap<String, String> extras = new HashMap<String, String>();
        if ("emulator".equals(app)) {
            if (len > 3) {
                extras.put("glm", this.sanitizeGlArg(arguments[3]));
            }
            if (len > 4) {
                extras.put("glr", this.sanitizeGlArg(arguments[4]));
            }
            if (len > 5) {
                extras.put("glv", this.sanitizeGlArg(arguments[5]));
            }
        }
        this.doPing(app, version, extras);
    }

    private String sanitizeGlArg(String arg) {
        if (arg == null) {
            arg = "";
        } else {
            try {
                arg = arg.trim();
                arg = arg.replaceAll("[^A-Za-z0-9\\s_()./-]", " ");
                arg = arg.replaceAll("\\s\\s+", " ");
                if (arg.length() > 128) {
                    arg = arg.substring(0, 128);
                }
                arg = URLEncoder.encode(arg, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                arg = "";
            }
        }
        return arg;
    }

    public void checkUserPermissionForPing(Shell parent) {
        if (!this.mStore.hasPingId()) {
            this.askUserPermissionForPing(parent);
            this.mStore.generateNewPingId();
        }
    }

    private void askUserPermissionForPing(final Shell parent) {
        Display display = parent.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                SdkStatsPermissionDialog dialog = new SdkStatsPermissionDialog(parent);
                dialog.open();
                SdkStatsService.this.mStore.setPingOptIn(dialog.getPingUserPreference());
            }
        });
    }

    protected void doPing(String app, String version, final Map<String, String> extras) {
        long then;
        final String nApp = this.normalizeAppName(app);
        final String nVersion = this.normalizeVersion(version);
        if (!this.mStore.isPingOptIn()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - (then = this.mStore.getPingTime(app)) < 86400000L) {
            return;
        }
        this.mStore.setPingTime(app, now);
        final long id = this.mStore.getPingId();
        new Thread(){

            @Override
            public void run() {
                try {
                    URL url = SdkStatsService.this.createPingUrl(nApp, nVersion, id, extras);
                    SdkStatsService.this.actuallySendPing(url);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private void actuallySendPing(URL url) throws IOException {
        HttpURLConnection conn;
        assert (url != null);
        if (DEBUG) {
            System.err.println("Ping: " + url.toString());
        }
        if ((conn = (HttpURLConnection)url.openConnection()).getResponseCode() != 200 && conn.getResponseCode() != 404) {
            throw new IOException(conn.getResponseMessage() + ": " + url);
        }
    }

    protected URL createPingUrl(String app, String version, long id, Map<String, String> extras) throws UnsupportedEncodingException, MalformedURLException {
        String osName = URLEncoder.encode(this.getOsName(), "UTF-8");
        String osArch = URLEncoder.encode(this.getOsArch(), "UTF-8");
        String jvmArch = URLEncoder.encode(this.getJvmInfo(), "UTF-8");
        String extraStr = "";
        if (extras != null && !extras.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : extras.entrySet()) {
                sb.append('&').append(entry.getKey()).append('=').append(entry.getValue());
            }
            extraStr = sb.toString();
        }
        URL url = new URL("http", "tools.google.com", "/service/update?as=androidsdk_" + app + "&id=" + Long.toHexString(id) + "&version=" + version + "&os=" + osName + "&osa=" + osArch + "&vma=" + jvmArch + extraStr);
        return url;
    }

    protected String getOsName() {
        String os = this.getSystemProperty(SYS_PROP_OS_NAME);
        if (os == null || os.length() == 0) {
            return "unknown";
        }
        String os2 = os.toLowerCase(Locale.US);
        if (os2.startsWith("mac")) {
            os = "mac";
            String osVers = this.getOsVersion();
            if (osVers != null) {
                os = os + '-' + osVers;
            }
        } else if (os2.startsWith("win")) {
            os = "win";
            String osVers = this.getOsVersion();
            if (osVers != null) {
                os = os + '-' + osVers;
            }
        } else if (os2.startsWith("linux")) {
            os = "linux";
        } else if (os.length() > 32) {
            os = os.substring(0, 32);
        }
        return os;
    }

    protected String getOsArch() {
        String arch = this.getJvmArch();
        if ("x86_64".equals(arch)) {
            return arch;
        }
        if ("x86".equals(arch)) {
            String os = this.getOsName();
            if (os.startsWith("win")) {
                String w6432 = this.getSystemEnv("PROCESSOR_ARCHITEW6432");
                if (w6432 != null && w6432.indexOf("64") != -1) {
                    return "x86_64";
                }
            } else if (os.startsWith("linux")) {
                String s = this.getSystemEnv("HOSTTYPE");
                if ((s = this.sanitizeOsArch(s)).indexOf("86") != -1) {
                    arch = s;
                }
            }
        }
        return arch;
    }

    protected String getOsVersion() {
        Matcher m;
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        String osVers = this.getSystemProperty(SYS_PROP_OS_VERSION);
        if (osVers != null && osVers.length() > 0 && (m = p.matcher(osVers)).matches()) {
            return m.group(1) + '.' + m.group(2);
        }
        return null;
    }

    protected String getJvmInfo() {
        return this.getJvmVersion() + '-' + this.getJvmArch();
    }

    protected String getJvmVersion() {
        String version = this.getSystemProperty(SYS_PROP_JAVA_VERSION);
        if (version == null || version.length() == 0) {
            return "unknown";
        }
        Pattern p = Pattern.compile("(\\d+)\\.(\\d+).*");
        Matcher m = p.matcher(version);
        if (m.matches()) {
            return m.group(1) + '.' + m.group(2);
        }
        if (version.length() > 8) {
            version = version.substring(0, 8);
        }
        return version;
    }

    protected String getJvmArch() {
        String arch = this.getSystemProperty(SYS_PROP_OS_ARCH);
        return this.sanitizeOsArch(arch);
    }

    private String sanitizeOsArch(String arch) {
        if (arch == null || arch.length() == 0) {
            return "unknown";
        }
        if (arch.equalsIgnoreCase("x86_64") || arch.equalsIgnoreCase("ia64") || arch.equalsIgnoreCase("amd64")) {
            return "x86_64";
        }
        if (arch.length() >= 4 && arch.charAt(0) == 'i' && arch.indexOf("86") == 2) {
            return "x86";
        }
        if (arch.equalsIgnoreCase("PowerPC")) {
            return "ppc";
        }
        if (arch.length() > 32) {
            arch = arch.substring(0, 32);
        }
        return arch;
    }

    protected String normalizeAppName(String app) {
        String app2 = app.replaceAll("\\W", "");
        if (app.length() == 0) {
            throw new IllegalArgumentException("Bad app name: " + app);
        }
        return app2;
    }

    protected String normalizeVersion(String version) {
        Pattern regex = Pattern.compile("^(\\d+)(?:\\.(\\d+))?(?:\\.(\\d+))?(?:\\.(\\d+)| +rc(\\d+))?");
        Matcher m = regex.matcher(version);
        if (m != null && m.lookingAt()) {
            StringBuilder normal = new StringBuilder();
            for (int i = 1; i <= 4; ++i) {
                int v = 0;
                if (i == 4 && i < m.groupCount() && m.group(i) == null && m.group(i + 1) != null) {
                    ++i;
                }
                if (m.group(i) != null) {
                    try {
                        v = Integer.parseInt(m.group(i));
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (i > 1) {
                    normal.append('.');
                }
                normal.append(v);
            }
            return normal.toString();
        }
        throw new IllegalArgumentException("Bad version: " + version);
    }

    protected String getSystemProperty(String name) {
        return System.getProperty(name);
    }

    protected String getSystemEnv(String name) {
        return System.getenv(name);
    }
}

