/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.search.checkers.QueryOptionsChecker;
import com.google.appengine.api.search.query.QueryTreeBuilder;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;

public final class QueryChecker {
    public static String checkQuery(String query) {
        Preconditions.checkNotNull(query, "query cannot be null");
        try {
            new QueryTreeBuilder().parse(query);
        }
        catch (RecognitionException e) {
            throw new SearchQueryException("Unable to parse query: " + e.getMessage());
        }
        return query;
    }

    public static SearchServicePb.SearchParams checkValid(SearchServicePb.SearchParams params) {
        IndexChecker.checkName(params.getIndexSpec().getName());
        QueryChecker.checkQuery(params.getQuery());
        QueryOptionsChecker.checkValid(params);
        return params;
    }
}

