/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import java.util.Collections;
import java.util.Date;
import java.util.Set;

public class Version {
    public static final Version UNKNOWN = new Version(null, null, null);
    private final String release;
    private final Date timestamp;
    private final Set<String> apiVersions;

    Version(String release, Date timestamp, Set<String> apiVersions) {
        this.release = release;
        this.timestamp = timestamp;
        this.apiVersions = apiVersions == null ? null : Collections.unmodifiableSet(apiVersions);
    }

    public String getRelease() {
        return this.release;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Set<String> getApiVersions() {
        return this.apiVersions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.release == null) {
            builder.append("Release: (unknown)\n");
        } else {
            builder.append("Release: " + this.release + "\n");
        }
        if (this.timestamp == null) {
            builder.append("Timestamp: (unknown)\n");
        } else {
            builder.append("Timestamp: " + this.timestamp + "\n");
        }
        if (this.apiVersions != null) {
            builder.append("API versions: " + this.apiVersions + "\n");
        } else {
            builder.append("API versions: (unknown)\n");
        }
        return builder.toString();
    }
}

