/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AbstractConfigXmlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.WebXml;
import java.io.InputStream;
import java.net.URL;
import java.util.Stack;
import org.mortbay.xml.XmlParser;

public class WebXmlReader
extends AbstractConfigXmlReader<WebXml> {
    private static final String[] DEFAULT_WELCOME_FILES = new String[]{"index.html", "index.jsp"};
    public static final String DEFAULT_RELATIVE_FILENAME = "WEB-INF/web.xml";
    private static final String URLPATTERN_TAG = "url-pattern";
    private static final String SERVLETMAP_TAG = "servlet-mapping";
    private static final String FILTERMAP_TAG = "filter-mapping";
    private static final String SECURITYCONST_TAG = "security-constraint";
    private static final String AUTHCONST_TAG = "auth-constraint";
    private static final String ROLENAME_TAG = "role-name";
    private static final String USERDATACONST_TAG = "user-data-constraint";
    private static final String TRANSGUARANTEE_TAG = "transport-guarantee";
    private static final String WELCOME_FILE_LIST_TAG = "welcome-file-list";
    private static final String WELCOME_FILE_TAG = "welcome-file";
    private static final String EXTENSION_TAG = "extension";
    private static final String MIME_TYPE_TAG = "mime-type";
    private static final String ERROR_CODE_TAG = "error-code";
    private final String relativeFilename;

    public WebXmlReader(String appDir, String relativeFilename) {
        super(appDir, true);
        this.relativeFilename = relativeFilename;
    }

    public WebXmlReader(String appDir) {
        this(appDir, DEFAULT_RELATIVE_FILENAME);
    }

    @Override
    protected String getRelativeFilename() {
        return this.relativeFilename;
    }

    public WebXml readWebXml() {
        return (WebXml)this.readConfigXml();
    }

    @Override
    protected XmlParser createXmlParser() {
        XmlParser xmlParser = new XmlParser();
        URL dtd22 = this.getClass().getResource("/javax/servlet/resources/web-app_2_2.dtd");
        URL dtd23 = this.getClass().getResource("/javax/servlet/resources/web-app_2_3.dtd");
        URL jsp20xsd = this.getClass().getResource("/javax/servlet/resources/jsp_2_0.xsd");
        URL jsp21xsd = this.getClass().getResource("/javax/servlet/resources/jsp_2_1.xsd");
        URL j2ee14xsd = this.getClass().getResource("/javax/servlet/resources/j2ee_1_4.xsd");
        URL webapp24xsd = this.getClass().getResource("/javax/servlet/resources/web-app_2_4.xsd");
        URL webapp25xsd = this.getClass().getResource("/javax/servlet/resources/web-app_2_5.xsd");
        URL schemadtd = this.getClass().getResource("/javax/servlet/resources/XMLSchema.dtd");
        URL xmlxsd = this.getClass().getResource("/javax/servlet/resources/xml.xsd");
        URL webservice11xsd = this.getClass().getResource("/javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
        URL webservice12xsd = this.getClass().getResource("/javax/servlet/resources/javaee_web_services_client_1_2.xsd");
        URL datatypesdtd = this.getClass().getResource("/javax/servlet/resources/datatypes.dtd");
        xmlParser.redirectEntity("web-app_2_2.dtd", dtd22);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", dtd22);
        xmlParser.redirectEntity("web.dtd", dtd23);
        xmlParser.redirectEntity("web-app_2_3.dtd", dtd23);
        xmlParser.redirectEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", dtd23);
        xmlParser.redirectEntity("XMLSchema.dtd", schemadtd);
        xmlParser.redirectEntity("http://www.w3.org/2001/XMLSchema.dtd", schemadtd);
        xmlParser.redirectEntity("-//W3C//DTD XMLSCHEMA 200102//EN", schemadtd);
        xmlParser.redirectEntity("jsp_2_0.xsd", jsp20xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/jsp_2_0.xsd", jsp20xsd);
        xmlParser.redirectEntity("jsp_2_1.xsd", jsp21xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/javaee/jsp_2_1.xsd", jsp21xsd);
        xmlParser.redirectEntity("j2ee_1_4.xsd", j2ee14xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", j2ee14xsd);
        xmlParser.redirectEntity("web-app_2_4.xsd", webapp24xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", webapp24xsd);
        xmlParser.redirectEntity("web-app_2_5.xsd", webapp25xsd);
        xmlParser.redirectEntity("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", webapp25xsd);
        xmlParser.redirectEntity("xml.xsd", xmlxsd);
        xmlParser.redirectEntity("http://www.w3.org/2001/xml.xsd", xmlxsd);
        xmlParser.redirectEntity("datatypes.dtd", datatypesdtd);
        xmlParser.redirectEntity("http://www.w3.org/2001/datatypes.dtd", datatypesdtd);
        xmlParser.redirectEntity("j2ee_web_services_client_1_1.xsd", webservice11xsd);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", webservice11xsd);
        xmlParser.redirectEntity("javaee_web_services_client_1_2.xsd", webservice12xsd);
        xmlParser.redirectEntity("http://www.ibm.com/webservices/xsd/javaee_web_services_client_1_2.xsd", webservice12xsd);
        return xmlParser;
    }

    @Override
    protected WebXml processXml(InputStream is) {
        final WebXml webXml = new WebXml();
        this.parse(new AbstractConfigXmlReader.ParserCallback(){
            private WebXml.SecurityConstraint security;
            private String extension;

            @Override
            public void newNode(XmlParser.Node node, Stack<XmlParser.Node> ancestors) {
                String code;
                String thisTag = node.getTag().toLowerCase();
                String parentTag = null;
                if (ancestors.size() > 0) {
                    parentTag = ((XmlParser.Node)ancestors.get(ancestors.size() - 1)).getTag().toLowerCase();
                }
                if (WebXmlReader.URLPATTERN_TAG.equals(thisTag)) {
                    String pattern = WebXmlReader.this.getString(node);
                    if (WebXmlReader.SERVLETMAP_TAG.equals(parentTag) || WebXmlReader.FILTERMAP_TAG.equals(parentTag)) {
                        String id = node.getAttribute("id");
                        webXml.addServletPattern(pattern, id);
                    } else if (this.security != null) {
                        this.security.addUrlPattern(pattern);
                    }
                } else if (WebXmlReader.ROLENAME_TAG.equals(thisTag) && WebXmlReader.AUTHCONST_TAG.equals(parentTag)) {
                    if (this.security == null) {
                        throw new AppEngineConfigException(WebXmlReader.this.getFilename() + ": <" + WebXmlReader.ROLENAME_TAG + "> in <" + WebXmlReader.AUTHCONST_TAG + "> in unrecognized context");
                    }
                    this.security.setRequiredRole(WebXmlReader.this.parseRequiredRole(WebXmlReader.this.getString(node)));
                } else if (WebXmlReader.TRANSGUARANTEE_TAG.equals(thisTag) && WebXmlReader.USERDATACONST_TAG.equals(parentTag)) {
                    if (this.security == null) {
                        throw new AppEngineConfigException(WebXmlReader.this.getFilename() + ": <" + WebXmlReader.TRANSGUARANTEE_TAG + "> in <" + WebXmlReader.USERDATACONST_TAG + "> in unrecognized context");
                    }
                    this.security.setTransportGuarantee(WebXmlReader.this.parseTransportGuarantee(WebXmlReader.this.getString(node)));
                } else if (WebXmlReader.SECURITYCONST_TAG.equals(thisTag)) {
                    this.security = webXml.addSecurityConstraint();
                } else if (WebXmlReader.WELCOME_FILE_TAG.equals(thisTag)) {
                    if (!WebXmlReader.WELCOME_FILE_LIST_TAG.equals(parentTag)) {
                        throw new AppEngineConfigException(WebXmlReader.this.getFilename() + ": <" + WebXmlReader.WELCOME_FILE_TAG + "> in unrecognized context");
                    }
                    webXml.addWelcomeFile(WebXmlReader.this.getString(node));
                } else if (WebXmlReader.EXTENSION_TAG.equals(thisTag)) {
                    this.extension = WebXmlReader.this.getString(node);
                } else if (WebXmlReader.MIME_TYPE_TAG.equals(thisTag)) {
                    if (this.extension == null) {
                        throw new AppEngineConfigException(WebXmlReader.this.getFilename() + ": <" + WebXmlReader.MIME_TYPE_TAG + "> without <extension>.");
                    }
                    String mimeType = WebXmlReader.this.getString(node);
                    webXml.addMimeMapping(this.extension, mimeType);
                    this.extension = null;
                } else if (WebXmlReader.ERROR_CODE_TAG.equals(thisTag) && "404".equals(code = WebXmlReader.this.getString(node))) {
                    webXml.setFallThroughToRuntime(true);
                }
            }
        }, is);
        if (webXml.getWelcomeFiles().isEmpty()) {
            for (String welcomeFile : DEFAULT_WELCOME_FILES) {
                webXml.addWelcomeFile(welcomeFile);
            }
        }
        return webXml;
    }

    private WebXml.SecurityConstraint.RequiredRole parseRequiredRole(String role) {
        if ("*".equals(role)) {
            return WebXml.SecurityConstraint.RequiredRole.ANY_USER;
        }
        if ("admin".equals(role)) {
            return WebXml.SecurityConstraint.RequiredRole.ADMIN;
        }
        throw new AppEngineConfigException(this.getFilename() + ": " + "Unknown role-name: must be '*' or 'admin'");
    }

    private WebXml.SecurityConstraint.TransportGuarantee parseTransportGuarantee(String transportGuarantee) {
        if ("NONE".equalsIgnoreCase(transportGuarantee)) {
            return WebXml.SecurityConstraint.TransportGuarantee.NONE;
        }
        if ("INTEGRAL".equalsIgnoreCase(transportGuarantee)) {
            return WebXml.SecurityConstraint.TransportGuarantee.INTEGRAL;
        }
        if ("CONFIDENTIAL".equalsIgnoreCase(transportGuarantee)) {
            return WebXml.SecurityConstraint.TransportGuarantee.CONFIDENTIAL;
        }
        throw new AppEngineConfigException(this.getFilename() + ": " + "Unknown transport-guarantee: must be " + "NONE, INTEGRAL, or CONFIDENTIAL.");
    }
}

