/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.socket;

import com.google.appengine.api.socket.AppEngineSocketImpl;
import com.google.appengine.api.socket.SocketServicePb;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;

class AppEngineSocketOptions {
    static final Map<Integer, Option> OPTION_MAP = new HashMap<Integer, Option>(Option.values().length);

    private AppEngineSocketOptions() {
    }

    static {
        for (Option option : Option.values()) {
            if (option.opt == null) continue;
            OPTION_MAP.put(option.opt, option);
        }
    }

    public static enum Option {
        SO_LINGER_OPT(128, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_LINGER, new IntegerCheckFunction(), new BooleanCheckFunction(){

            @Override
            void apply(Option option, AppEngineSocketImpl socketImpl, Object val) throws SocketException {
                socketImpl.socketSetOption(option, false, val);
            }
        }),
        SO_TIMEOUT_OPT(4102, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, null, new IntegerCheckFunction(){

            @Override
            void check(Option opt, Object value) {
                if ((Integer)value < 0) {
                    throw new IllegalArgumentException(opt.optionName() + " requires timeout value >= 0: timeout given = " + value);
                }
            }

            @Override
            void apply(Option option, AppEngineSocketImpl socketImpl, Object value) throws SocketException {
                socketImpl.soTimeout = (Integer)value;
                socketImpl.socketSetOption(option, true, value);
            }
        }),
        IP_TOS_OPT(3, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_IP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_IP_TOS, new IntegerCheckFunction()),
        SO_BINDADDR_OPT(15, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, null, new UnimplimentedCheckFunction()),
        TCP_NODELAY_OPT(1, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_NODELAY, new BooleanCheckFunction()),
        SO_SNDBUF_OPT(4097, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_SNDBUF, new GreaterThanZeroCheckFunction()),
        SO_RCVBUF_OPT(4098, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_RCVBUF, new GreaterThanZeroCheckFunction()),
        SO_KEEPALIVE_OPT(8, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_KEEPALIVE, new BooleanCheckFunction()),
        SO_OOBINLINE_OPT(4099, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_OOBINLINE, new BooleanCheckFunction()),
        SO_REUSEADDR_OPT(4, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_REUSEADDR, new BooleanCheckFunction()),
        SO_DEBUG_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_DEBUG, new BooleanCheckFunction()),
        SO_TYPE_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_TYPE, new BooleanCheckFunction()),
        SO_ERROR_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_ERROR, new CheckFunction[0]),
        SO_DONTROUTE_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_DONTROUTE, new BooleanCheckFunction()),
        SO_BROADCAST_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_SOCKET, SocketServicePb.SocketOption.SocketOptionName.SOCKET_SO_BROADCAST, new BooleanCheckFunction()),
        IP_TTL_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_IP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_IP_TTL, new BooleanCheckFunction()),
        IP_HDRINCL_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_IP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_IP_HDRINCL, new BooleanCheckFunction()),
        IP_OPTIONS_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_IP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_IP_OPTIONS, new BooleanCheckFunction()),
        TCP_MAXSEG_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_MAXSEG, new IntegerCheckFunction()),
        TCP_CORK_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_CORK, new BooleanCheckFunction()),
        TCP_KEEPIDLE_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_KEEPIDLE, new BooleanCheckFunction()),
        TCP_KEEPINTVL_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_KEEPINTVL, new BooleanCheckFunction()),
        TCP_KEEPCNT_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_KEEPCNT, new IntegerCheckFunction()),
        TCP_SYNCNT_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_SYNCNT, new IntegerCheckFunction()),
        TCP_LINGER2_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_LINGER2, new BooleanCheckFunction()),
        TCP_DEFER_ACCEPT_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_DEFER_ACCEPT, new BooleanCheckFunction()),
        TCP_WINDOW_CLAMP_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_WINDOW_CLAMP, new BooleanCheckFunction()),
        TCP_INFO_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_INFO, new BooleanCheckFunction()),
        TCP_QUICKACK_OPT(null, SocketServicePb.SocketOption.SocketOptionLevel.SOCKET_SOL_TCP, SocketServicePb.SocketOption.SocketOptionName.SOCKET_TCP_QUICKACK, new BooleanCheckFunction());

        private SocketServicePb.SocketOption.SocketOptionLevel level;
        private SocketServicePb.SocketOption.SocketOptionName optName;
        private Integer opt;
        private CheckFunction[] checkFuncs;

        private Option(Integer opt, SocketServicePb.SocketOption.SocketOptionLevel level, SocketServicePb.SocketOption.SocketOptionName name, CheckFunction ... checkFuncs) {
            this.optName = name;
            this.level = level;
            this.opt = opt;
            this.checkFuncs = checkFuncs;
        }

        String optionName() {
            return this.name().substring(0, this.name().length() - "_OPT".length());
        }

        void validateAndApply(AppEngineSocketImpl socketImpl, Object val) throws SocketException {
            if (val == null) {
                throw new SocketException("Bad parameter type of 'null' for option " + this.optionName());
            }
            for (CheckFunction checkFunc : this.checkFuncs) {
                if (!val.getClass().isInstance(checkFunc.equivalenceClassObject())) continue;
                checkFunc.check(this, val);
                checkFunc.apply(this, socketImpl, val);
                return;
            }
            throw new SocketException("Bad parameter type of '" + val.getClass().getName() + "' for option " + this.optionName());
        }

        public SocketServicePb.SocketOption.SocketOptionLevel getLevel() {
            return this.level;
        }

        public SocketServicePb.SocketOption.SocketOptionName getOptName() {
            return this.optName;
        }

        public Integer getOpt() {
            return this.opt;
        }
    }

    private static class GreaterThanZeroCheckFunction
    extends IntegerCheckFunction {
        private GreaterThanZeroCheckFunction() {
        }

        @Override
        void check(Option opt, Object value) throws SocketException {
            if ((Integer)value <= 0) {
                throw new SocketException("bad parameter for '" + opt.optionName() + "'" + " Must be greater than zero. value = " + value);
            }
        }
    }

    private static class UnimplimentedCheckFunction
    extends CheckFunction {
        private UnimplimentedCheckFunction() {
        }

        @Override
        Object equivalenceClassObject() {
            return new Object();
        }

        @Override
        void check(Option opt, Object value) throws SocketException {
            throw new SocketException(opt.optionName() + " is not implimented.");
        }
    }

    private static class BooleanCheckFunction
    extends CheckFunction {
        private BooleanCheckFunction() {
        }

        @Override
        Object equivalenceClassObject() {
            return false;
        }

        @Override
        void apply(Option option, AppEngineSocketImpl socketImpl, Object value) throws SocketException {
            socketImpl.socketSetOption(option, (Boolean)value, value);
        }
    }

    private static class IntegerCheckFunction
    extends CheckFunction {
        private IntegerCheckFunction() {
        }

        @Override
        Object equivalenceClassObject() {
            return 0;
        }
    }

    private static abstract class CheckFunction {
        private CheckFunction() {
        }

        abstract Object equivalenceClassObject();

        void check(Option opt, Object value) throws SocketException {
        }

        void apply(Option option, AppEngineSocketImpl socketImpl, Object value) throws SocketException {
            socketImpl.socketSetOption(option, true, value);
        }
    }
}

