/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public final class IMHandle
implements Serializable,
Comparable<IMHandle> {
    public static final long serialVersionUID = 6963426833434504530L;
    private String protocol;
    private String address;

    public IMHandle(Scheme scheme, String address) {
        if (scheme == null) {
            throw new NullPointerException("scheme must not be null");
        }
        IMHandle.validateAddress(address);
        this.protocol = scheme.name();
        this.address = address;
    }

    public IMHandle(URL network, String address) {
        if (network == null) {
            throw new NullPointerException("network must not be null");
        }
        IMHandle.validateAddress(address);
        this.protocol = network.toString();
        this.address = address;
    }

    private IMHandle() {
        this.protocol = null;
        this.address = null;
    }

    static IMHandle fromDatastoreString(String datastoreString) {
        if (datastoreString == null) {
            throw new NullPointerException("datastoreString must not be null");
        }
        String[] split = datastoreString.split(" ", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("Datastore string must have at least one space: " + datastoreString);
        }
        try {
            return new IMHandle(Scheme.valueOf(split[0]), split[1]);
        }
        catch (IllegalArgumentException iae) {
            try {
                return new IMHandle(new URL(split[0]), split[1]);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("String in datastore could not be parsed into a valid IMHandle.  Protocol must either be a valid scheme or url: " + split[0]);
            }
        }
    }

    private static void validateAddress(String address) {
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
    }

    String toDatastoreString() {
        return String.format("%s %s", this.protocol, this.address);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IMHandle imHandle = (IMHandle)o;
        if (!this.address.equals(imHandle.address)) {
            return false;
        }
        return this.protocol.equals(imHandle.protocol);
    }

    public int hashCode() {
        int result = this.protocol.hashCode();
        result = 31 * result + this.address.hashCode();
        return result;
    }

    @Override
    public int compareTo(IMHandle o) {
        return this.toDatastoreString().compareTo(o.toDatastoreString());
    }

    public String toString() {
        return this.toDatastoreString();
    }

    public static enum Scheme {
        sip,
        unknown,
        xmpp;

    }
}

