/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.memcache.AsyncMemcacheServiceImpl;
import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.Stats;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

class MemcacheServiceImpl
implements MemcacheService {
    private final AsyncMemcacheServiceImpl async;

    MemcacheServiceImpl(String namespace) {
        this.async = new AsyncMemcacheServiceImpl(namespace);
    }

    private static <T> T quietGet(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MemcacheServiceException("Unexpected failure", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new UndeclaredThrowableException(cause);
        }
    }

    @Override
    public boolean contains(Object key) {
        return MemcacheServiceImpl.quietGet(this.async.contains(key));
    }

    @Override
    public Object get(Object key) {
        return MemcacheServiceImpl.quietGet(this.async.get(key));
    }

    @Override
    public MemcacheService.IdentifiableValue getIdentifiable(Object key) {
        return MemcacheServiceImpl.quietGet(this.async.getIdentifiable(key));
    }

    @Override
    public <T> Map<T, MemcacheService.IdentifiableValue> getIdentifiables(Collection<T> keys) {
        return MemcacheServiceImpl.quietGet(this.async.getIdentifiables(keys));
    }

    @Override
    public <T> Map<T, Object> getAll(Collection<T> keys) {
        return MemcacheServiceImpl.quietGet(this.async.getAll(keys));
    }

    @Override
    public boolean put(Object key, Object value, Expiration expires, MemcacheService.SetPolicy policy) {
        return MemcacheServiceImpl.quietGet(this.async.put(key, value, expires, policy));
    }

    @Override
    public void put(Object key, Object value, Expiration expires) {
        MemcacheServiceImpl.quietGet(this.async.put(key, value, expires));
    }

    @Override
    public void put(Object key, Object value) {
        MemcacheServiceImpl.quietGet(this.async.put(key, value));
    }

    @Override
    public boolean putIfUntouched(Object key, MemcacheService.IdentifiableValue oldValue, Object newValue, Expiration expires) {
        return MemcacheServiceImpl.quietGet(this.async.putIfUntouched(key, oldValue, newValue, expires));
    }

    @Override
    public boolean putIfUntouched(Object key, MemcacheService.IdentifiableValue oldValue, Object newValue) {
        return MemcacheServiceImpl.quietGet(this.async.putIfUntouched(key, oldValue, newValue));
    }

    @Override
    public <T> Set<T> putIfUntouched(Map<T, MemcacheService.CasValues> values) {
        return MemcacheServiceImpl.quietGet(this.async.putIfUntouched(values));
    }

    @Override
    public <T> Set<T> putIfUntouched(Map<T, MemcacheService.CasValues> values, Expiration expiration) {
        return MemcacheServiceImpl.quietGet(this.async.putIfUntouched(values, expiration));
    }

    @Override
    public <T> Set<T> putAll(Map<T, ?> values, Expiration expires, MemcacheService.SetPolicy policy) {
        return MemcacheServiceImpl.quietGet(this.async.putAll(values, expires, policy));
    }

    @Override
    public void putAll(Map<?, ?> values, Expiration expires) {
        MemcacheServiceImpl.quietGet(this.async.putAll(values, expires));
    }

    @Override
    public void putAll(Map<?, ?> values) {
        MemcacheServiceImpl.quietGet(this.async.putAll(values));
    }

    @Override
    public boolean delete(Object key) {
        return MemcacheServiceImpl.quietGet(this.async.delete(key));
    }

    @Override
    public boolean delete(Object key, long millisNoReAdd) {
        return MemcacheServiceImpl.quietGet(this.async.delete(key, millisNoReAdd));
    }

    @Override
    public <T> Set<T> deleteAll(Collection<T> keys) {
        return MemcacheServiceImpl.quietGet(this.async.deleteAll(keys));
    }

    @Override
    public <T> Set<T> deleteAll(Collection<T> keys, long millisNoReAdd) {
        return MemcacheServiceImpl.quietGet(this.async.deleteAll(keys, millisNoReAdd));
    }

    @Override
    public Long increment(Object key, long delta) {
        return MemcacheServiceImpl.quietGet(this.async.increment(key, delta));
    }

    @Override
    public Long increment(Object key, long delta, Long initialValue) {
        return MemcacheServiceImpl.quietGet(this.async.increment(key, delta, initialValue));
    }

    @Override
    public <T> Map<T, Long> incrementAll(Collection<T> keys, long delta) {
        return MemcacheServiceImpl.quietGet(this.async.incrementAll(keys, delta));
    }

    @Override
    public <T> Map<T, Long> incrementAll(Collection<T> keys, long delta, Long initialValue) {
        return MemcacheServiceImpl.quietGet(this.async.incrementAll(keys, delta, initialValue));
    }

    @Override
    public <T> Map<T, Long> incrementAll(Map<T, Long> offsets) {
        return MemcacheServiceImpl.quietGet(this.async.incrementAll(offsets));
    }

    @Override
    public <T> Map<T, Long> incrementAll(Map<T, Long> offsets, Long initialValue) {
        return MemcacheServiceImpl.quietGet(this.async.incrementAll(offsets, initialValue));
    }

    @Override
    public void clearAll() {
        MemcacheServiceImpl.quietGet(this.async.clearAll());
    }

    @Override
    public Stats getStatistics() {
        return MemcacheServiceImpl.quietGet(this.async.getStatistics());
    }

    @Override
    public String getNamespace() {
        return this.async.getNamespace();
    }

    @Override
    @Deprecated
    public void setNamespace(String newNamespace) {
        this.async.setNamespace(newNamespace);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.async.getErrorHandler();
    }

    @Override
    public void setErrorHandler(ErrorHandler newHandler) {
        this.async.setErrorHandler(newHandler);
    }
}

