/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.AddDocumentsResponse;
import com.google.appengine.api.search.AddException;
import com.google.appengine.api.search.Consistency;
import com.google.appengine.api.search.Cursor;
import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.FutureHelper;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.IndexSpec;
import com.google.appengine.api.search.ListDocumentsException;
import com.google.appengine.api.search.ListRequest;
import com.google.appengine.api.search.ListResponse;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Query;
import com.google.appengine.api.search.RemoveException;
import com.google.appengine.api.search.Results;
import com.google.appengine.api.search.Schema;
import com.google.appengine.api.search.ScoredDocument;
import com.google.appengine.api.search.SearchApiHelper;
import com.google.appengine.api.search.SearchException;
import com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.api.search.StatusCode;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.DocumentChecker;
import com.google.appengine.api.search.checkers.Preconditions;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;

class IndexImpl
implements Index {
    private final SearchApiHelper apiHelper;
    private final IndexSpec spec;
    private final String namespace;
    private final Schema schema;

    IndexImpl(SearchApiHelper apiHelper, String namespace, IndexSpec indexSpec) {
        this(apiHelper, namespace, indexSpec, null);
    }

    IndexImpl(SearchApiHelper apiHelper, String namespace, IndexSpec indexSpec, Schema schema) {
        this.apiHelper = Preconditions.checkNotNull(apiHelper, "Internal error");
        this.namespace = Preconditions.checkNotNull(namespace, "Internal error");
        this.spec = Preconditions.checkNotNull(indexSpec, "Internal error");
        this.schema = schema;
    }

    @Override
    public String getName() {
        return this.spec.getName();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Consistency getConsistency() {
        return this.spec.getConsistency();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.spec.hashCode();
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexImpl other = (IndexImpl)obj;
        return Util.equalObjects(this.spec, other.spec) && Util.equalObjects(this.schema, other.schema);
    }

    public String toString() {
        return String.format("IndexImpl{namespace: %s, %s, %s}", this.namespace, this.spec, this.schema == null ? "(null schema)" : this.schema);
    }

    @Override
    public Future<Void> removeAsync(String ... documentIds) {
        return this.removeAsync(Arrays.asList(documentIds));
    }

    @Override
    public Future<Void> removeAsync(Iterable<String> documentIds) {
        Preconditions.checkArgument(documentIds != null, "Delete documents given null collection of document ids");
        SearchServicePb.DeleteDocumentParams.Builder builder = SearchServicePb.DeleteDocumentParams.newBuilder().setIndexSpec(this.spec.copyToProtocolBuffer(this.namespace));
        int size = 0;
        for (String documentId : documentIds) {
            ++size;
            builder.addDocId(DocumentChecker.checkDocumentId(documentId));
        }
        if (size > 200) {
            throw new IllegalArgumentException(String.format("number of doc ids, %s, exceeds maximum %s", size, 200));
        }
        final int documentIdsSize = size;
        SearchServicePb.DeleteDocumentRequest request = SearchServicePb.DeleteDocumentRequest.newBuilder().setParams(builder).build();
        SearchServicePb.DeleteDocumentResponse.Builder responseBuilder = SearchServicePb.DeleteDocumentResponse.newBuilder();
        Future<SearchServicePb.DeleteDocumentResponse.Builder> future = this.apiHelper.makeAsyncCall("DeleteDocument", request, responseBuilder);
        return new FutureWrapper<SearchServicePb.DeleteDocumentResponse.Builder, Void>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new RemoveException(result);
            }

            @Override
            protected Void wrap(SearchServicePb.DeleteDocumentResponse.Builder key) throws Exception {
                SearchServicePb.DeleteDocumentResponse response = key.build();
                ArrayList<OperationResult> results = new ArrayList<OperationResult>(response.getStatusCount());
                for (SearchServicePb.RequestStatus status : response.getStatusList()) {
                    results.add(new OperationResult(status));
                }
                if (documentIdsSize != response.getStatusList().size()) {
                    throw new RemoveException(new OperationResult(StatusCode.INTERNAL_ERROR, String.format("Expected %d removed documents, but got %d", documentIdsSize, response.getStatusList().size())), results);
                }
                for (OperationResult result : results) {
                    if (result.getCode() == StatusCode.OK) continue;
                    throw new RemoveException(result, results);
                }
                return null;
            }
        };
    }

    @Override
    public Future<AddDocumentsResponse> addAsync(Document ... documents) {
        return this.addAsync(Arrays.asList(documents));
    }

    @Override
    public Future<AddDocumentsResponse> addAsync(Iterable<Document> documents) {
        Preconditions.checkNotNull(documents, "document list cannot be null");
        if (!documents.iterator().hasNext()) {
            return new FutureHelper.FakeFuture<AddDocumentsResponse>(new AddDocumentsResponse(Collections.<OperationResult>emptyList(), Collections.<String>emptyList()));
        }
        SearchServicePb.IndexDocumentParams.Builder builder = SearchServicePb.IndexDocumentParams.newBuilder().setIndexSpec(this.spec.copyToProtocolBuffer(this.namespace));
        int size = 0;
        for (Document document : documents) {
            ++size;
            builder.addDocument(Preconditions.checkNotNull(document, "document cannot be null").copyToProtocolBuffer());
        }
        if (size > 200) {
            throw new IllegalArgumentException(String.format("number of documents, %s, exceeds maximum %s", size, 200));
        }
        final int documentsSize = size;
        SearchServicePb.IndexDocumentRequest request = SearchServicePb.IndexDocumentRequest.newBuilder().setParams(builder).build();
        SearchServicePb.IndexDocumentResponse.Builder responseBuilder = SearchServicePb.IndexDocumentResponse.newBuilder();
        Future<SearchServicePb.IndexDocumentResponse.Builder> future = this.apiHelper.makeAsyncCall("IndexDocument", request, responseBuilder);
        return new FutureWrapper<SearchServicePb.IndexDocumentResponse.Builder, AddDocumentsResponse>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new AddException(result);
            }

            @Override
            protected AddDocumentsResponse wrap(SearchServicePb.IndexDocumentResponse.Builder key) throws Exception {
                SearchServicePb.IndexDocumentResponse response = key.build();
                List<OperationResult> results = this.newOperationResultList(response);
                if (documentsSize != response.getStatusList().size()) {
                    throw new AddException(new OperationResult(StatusCode.INTERNAL_ERROR, String.format("Expected %d indexed documents, but got %d", documentsSize, response.getStatusList().size())), results, response.getDocIdList());
                }
                for (OperationResult result : results) {
                    if (result.getCode() == StatusCode.OK) continue;
                    throw new AddException(result, results, response.getDocIdList());
                }
                return new AddDocumentsResponse(results, response.getDocIdList());
            }

            private List<OperationResult> newOperationResultList(SearchServicePb.IndexDocumentResponse response) {
                ArrayList<OperationResult> results = new ArrayList<OperationResult>(response.getStatusCount());
                for (SearchServicePb.RequestStatus status : response.getStatusList()) {
                    results.add(new OperationResult(status));
                }
                return results;
            }
        };
    }

    private Future<Results<ScoredDocument>> executeSearchForResults(SearchServicePb.SearchParams.Builder params) {
        SearchServicePb.SearchResponse.Builder responseBuilder = SearchServicePb.SearchResponse.newBuilder();
        SearchServicePb.SearchRequest request = SearchServicePb.SearchRequest.newBuilder().setParams(params).build();
        Future<SearchServicePb.SearchResponse.Builder> future = this.apiHelper.makeAsyncCall("Search", request, responseBuilder);
        return new FutureWrapper<SearchServicePb.SearchResponse.Builder, Results<ScoredDocument>>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new SearchException(result);
            }

            @Override
            protected Results<ScoredDocument> wrap(SearchServicePb.SearchResponse.Builder key) throws Exception {
                SearchServicePb.SearchResponse response = key.build();
                SearchServicePb.RequestStatus status = response.getStatus();
                if (status.getCode() != SearchServicePb.SearchServiceError.ErrorCode.OK) {
                    throw new SearchException(new OperationResult(status));
                }
                ArrayList<ScoredDocument> scoredDocs = new ArrayList<ScoredDocument>();
                for (SearchServicePb.SearchResult result : response.getResultList()) {
                    ArrayList<Field> expressions = new ArrayList<Field>();
                    for (DocumentPb.Field expression : result.getExpressionList()) {
                        expressions.add(Field.newBuilder(expression).build());
                    }
                    ScoredDocument.Builder scoredDocBuilder = ScoredDocument.newBuilder(result.getDocument());
                    for (Double score : result.getScoreList()) {
                        scoredDocBuilder.addScore(score);
                    }
                    for (Field expression : expressions) {
                        scoredDocBuilder.addExpression(expression);
                    }
                    if (result.hasCursor()) {
                        scoredDocBuilder.setCursor(Cursor.newBuilder().build("true:" + result.getCursor()));
                    }
                    scoredDocs.add(scoredDocBuilder.build());
                }
                Results<ScoredDocument> scoredResults = new Results<ScoredDocument>(new OperationResult(status), scoredDocs, response.getMatchedCount(), response.getResultCount(), response.hasCursor() ? Cursor.newBuilder().build("false:" + response.getCursor()) : null);
                return scoredResults;
            }
        };
    }

    @Override
    public Future<Results<ScoredDocument>> searchAsync(String query) {
        return this.searchAsync(Query.newBuilder().build(Preconditions.checkNotNull(query, "query cannot be null")));
    }

    @Override
    public Future<Results<ScoredDocument>> searchAsync(Query query) {
        Preconditions.checkNotNull(query, "query cannot be null");
        return this.executeSearchForResults(query.copyToProtocolBuffer().setIndexSpec(this.spec.copyToProtocolBuffer(this.namespace)));
    }

    @Override
    public Future<ListResponse<Document>> listDocumentsAsync(ListRequest request) {
        Preconditions.checkNotNull(request, "list documents request cannot be null");
        SearchServicePb.ListDocumentsParams.Builder params = request.copyToProtocolBuffer().setIndexSpec(this.spec.copyToProtocolBuffer(this.namespace));
        SearchServicePb.ListDocumentsResponse.Builder responseBuilder = SearchServicePb.ListDocumentsResponse.newBuilder();
        SearchServicePb.ListDocumentsRequest requestPb = SearchServicePb.ListDocumentsRequest.newBuilder().setParams(params).build();
        Future<SearchServicePb.ListDocumentsResponse.Builder> future = this.apiHelper.makeAsyncCall("ListDocuments", requestPb, responseBuilder);
        return new FutureWrapper<SearchServicePb.ListDocumentsResponse.Builder, ListResponse<Document>>(future){

            @Override
            protected Throwable convertException(Throwable cause) {
                OperationResult result = OperationResult.convertToOperationResult(cause);
                return result == null ? cause : new ListDocumentsException(result);
            }

            @Override
            protected ListResponse<Document> wrap(SearchServicePb.ListDocumentsResponse.Builder key) throws Exception {
                SearchServicePb.ListDocumentsResponse response = key.build();
                SearchServicePb.RequestStatus status = response.getStatus();
                if (status.getCode() != SearchServicePb.SearchServiceError.ErrorCode.OK) {
                    throw new ListDocumentsException(new OperationResult(status));
                }
                ArrayList<Document> results = new ArrayList<Document>();
                for (DocumentPb.Document document : response.getDocumentList()) {
                    results.add(Document.newBuilder(document).build());
                }
                return new ListResponse<Document>(results);
            }
        };
    }

    @Override
    public void remove(String ... documentIds) {
        FutureHelper.quietGet(this.removeAsync(documentIds));
    }

    @Override
    public void remove(Iterable<String> documentIds) {
        FutureHelper.quietGet(this.removeAsync(documentIds));
    }

    @Override
    public AddDocumentsResponse add(Document ... documents) {
        return FutureHelper.quietGet(this.addAsync(documents));
    }

    @Override
    public AddDocumentsResponse add(Iterable<Document> documents) {
        return FutureHelper.quietGet(this.addAsync(documents));
    }

    @Override
    public Results<ScoredDocument> search(String query) {
        return FutureHelper.quietGet(this.searchAsync(query));
    }

    @Override
    public Results<ScoredDocument> search(Query query) {
        return FutureHelper.quietGet(this.searchAsync(query));
    }

    @Override
    public ListResponse<Document> listDocuments(ListRequest request) {
        return FutureHelper.quietGet(this.listDocumentsAsync(request));
    }
}

