/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient.auth;

import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthChallengeException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthPolicy;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthScheme;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthState;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.AuthenticationException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.auth.MalformedChallengeException;
import com.google.appengine.repackaged.org.apache.commons.httpclient.params.HttpParams;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.util.Collection;
import java.util.Map;

public final class AuthChallengeProcessor {
    private static final Log LOG = LogFactory.getLog(AuthChallengeProcessor.class);
    private HttpParams params = null;

    public AuthChallengeProcessor(HttpParams httpParams) {
        if (httpParams == null) {
            throw new IllegalArgumentException("Parameter collection may not be null");
        }
        this.params = httpParams;
    }

    public AuthScheme selectAuthScheme(Map map) throws AuthChallengeException {
        if (map == null) {
            throw new IllegalArgumentException("Challenge map may not be null");
        }
        Collection collection = (Collection)this.params.getParameter("http.auth.scheme-priority");
        if (collection == null || collection.isEmpty()) {
            collection = AuthPolicy.getDefaultAuthPrefs();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Supported authentication schemes in the order of preference: " + collection);
        }
        AuthScheme authScheme = null;
        String string = null;
        for (String string2 : collection) {
            string = (String)map.get(string2.toLowerCase());
            if (string != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info(string2 + " authentication scheme selected");
                }
                try {
                    authScheme = AuthPolicy.getAuthScheme(string2);
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                    throw new AuthChallengeException(illegalStateException.getMessage());
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Challenge for " + string2 + " authentication scheme not available");
        }
        if (authScheme == null) {
            throw new AuthChallengeException("Unable to respond to any of these challenges: " + map);
        }
        return authScheme;
    }

    public AuthScheme processChallenge(AuthState authState, Map map) throws MalformedChallengeException, AuthenticationException {
        String string;
        if (authState == null) {
            throw new IllegalArgumentException("Authentication state may not be null");
        }
        if (map == null) {
            throw new IllegalArgumentException("Challenge map may not be null");
        }
        if (authState.isPreemptive() || authState.getAuthScheme() == null) {
            authState.setAuthScheme(this.selectAuthScheme(map));
        }
        AuthScheme authScheme = authState.getAuthScheme();
        String string2 = authScheme.getSchemeName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using authentication scheme: " + string2);
        }
        if ((string = (String)map.get(string2.toLowerCase())) == null) {
            throw new AuthenticationException(string2 + " authorization challenge expected, but not found");
        }
        authScheme.processChallenge(string);
        LOG.debug("Authorization challenge processed");
        return authScheme;
    }
}

