/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.datanucleus;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.datanucleus.PrimitiveArrays;
import com.google.appengine.datanucleus.SerializationStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.ExtensionMetaData;

public class SerializationManager {
    static final String SERIALIZATION_STRATEGY_KEY = "serialization-strategy";
    public static final SerializationStrategy DEFAULT_SERIALIZATION_STRATEGY = new SerializationStrategy(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Blob serialize(Object obj) {
            Blob blob;
            if (obj == null) {
                throw new NullPointerException("Object cannot be null.");
            }
            if (obj instanceof byte[]) {
                return new Blob((byte[])obj);
            }
            if (obj instanceof Byte[]) {
                return new Blob(PrimitiveArrays.toByteArray(Arrays.asList((Byte[])obj)));
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                blob = new Blob(baos.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    finally {
                        if (oos != null) {
                            oos.close();
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NucleusException("Received IOException serializing object of type " + obj.getClass().getName(), (Throwable)ioe);
                }
            }
            try {
                baos.close();
            }
            finally {
                if (oos != null) {
                    oos.close();
                }
            }
            return blob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object deserialize(Blob blob, Class<?> targetClass) {
            Object object;
            if (blob == null) {
                throw new NullPointerException("Blob cannot be null.");
            }
            if (targetClass.equals(byte[].class)) {
                return blob.getBytes();
            }
            if (targetClass.equals(Byte[].class)) {
                byte[] bytes = blob.getBytes();
                return PrimitiveArrays.asList(bytes).toArray(new Byte[bytes.length]);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(blob.getBytes());
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(bais);
                Object obj = ois.readObject();
                if (!targetClass.isAssignableFrom(obj.getClass())) {
                    throw new NucleusException("Bytes in datastore comprise an object of type " + obj.getClass().getName() + " but expected type is " + targetClass.getName());
                }
                object = obj;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bais.close();
                    }
                    finally {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new NucleusException("Received IOException deserializing a byte array.", (Throwable)ioe);
                }
                catch (ClassNotFoundException cnfe) {
                    throw new NucleusException("Received ClassNotFoundException deserializing a byte array.", (Throwable)cnfe);
                }
            }
            try {
                bais.close();
            }
            finally {
                if (ois != null) {
                    ois.close();
                }
            }
            return object;
        }
    };

    Blob serialize(ClassLoaderResolver clr, AbstractMemberMetaData ammd, Object value) {
        SerializationStrategy serializationStrategy = this.getSerializationStrategy(clr, ammd);
        return serializationStrategy.serialize(value);
    }

    Object deserialize(ClassLoaderResolver clr, AbstractMemberMetaData ammd, Blob value) {
        SerializationStrategy serializationStrategy = this.getSerializationStrategy(clr, ammd);
        return serializationStrategy.deserialize(value, ammd.getType());
    }

    SerializationStrategy getSerializationStrategy(ClassLoaderResolver clr, AbstractMemberMetaData ammd) {
        ExtensionMetaData[] emdList = ammd.getExtensions();
        if (emdList != null) {
            for (ExtensionMetaData emd : emdList) {
                if (!emd.getKey().equals(SERIALIZATION_STRATEGY_KEY)) continue;
                Class clazz = clr.classForName(emd.getValue());
                if (!SerializationStrategy.class.isAssignableFrom(clazz)) {
                    throw new NucleusException("Custom serialization class " + emd.getValue() + " for member " + ammd.getFullFieldName() + " must implement " + SerializationStrategy.class);
                }
                try {
                    return (SerializationStrategy)clazz.newInstance();
                }
                catch (InstantiationException e) {
                    throw new NucleusException("Could not instantiate instance of " + clazz.getName(), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    throw new NucleusException("Could not instantiate instance of " + clazz.getName(), (Throwable)e);
                }
            }
        }
        return DEFAULT_SERIALIZATION_STRATEGY;
    }
}

