/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.resource.Resource;

public class StaticFileUtils {
    private static final Logger logger = Logger.getLogger(StaticFileUtils.class.getName());
    private static final String CACHE_CONTROL_VALUE = "private";
    private final ContextHandler.SContext servletContext;

    public StaticFileUtils(ContextHandler.SContext servletContext) {
        this.servletContext = servletContext;
    }

    public boolean serveWelcomeFileAsRedirect(String path, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (included) {
            return false;
        }
        response.setContentLength(0);
        String q = request.getQueryString();
        if (q != null && q.length() != 0) {
            response.sendRedirect(path + "?" + q);
        } else {
            response.sendRedirect(path);
        }
        return true;
    }

    public boolean serveWelcomeFileAsForward(RequestDispatcher dispatcher, boolean included, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!included && !request.getRequestURI().endsWith("/")) {
            this.redirectToAddSlash(request, response);
            return true;
        }
        request.setAttribute("com.google.appengine.tools.development.isWelcomeFile", (Object)true);
        if (dispatcher != null) {
            if (included) {
                dispatcher.include((ServletRequest)request, (ServletResponse)response);
            } else {
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            }
            return true;
        }
        return false;
    }

    public void redirectToAddSlash(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuffer buf = request.getRequestURL();
        int param = buf.lastIndexOf(";");
        if (param < 0) {
            buf.append('/');
        } else {
            buf.insert(param, '/');
        }
        String q = request.getQueryString();
        if (q != null && q.length() != 0) {
            buf.append('?');
            buf.append(q);
        }
        response.setContentLength(0);
        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
    }

    public boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals("HEAD")) {
            String ifms = request.getHeader("If-Modified-Since");
            if (ifms != null) {
                long ifmsl = -1L;
                try {
                    ifmsl = request.getDateHeader("If-Modified-Since");
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (ifmsl != -1L && resource.lastModified() <= ifmsl) {
                    response.reset();
                    response.setStatus(304);
                    response.flushBuffer();
                    return false;
                }
            }
            long date = -1L;
            try {
                date = request.getDateHeader("If-Unmodified-Since");
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (date != -1L && resource.lastModified() > date) {
                response.sendError(412);
                return false;
            }
        }
        return true;
    }

    public void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource) throws IOException {
        long contentLength = resource.length();
        if (!include) {
            this.writeHeaders(response, resource, contentLength);
        }
        Object out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        resource.writeTo((OutputStream)out, 0L, contentLength);
    }

    public void writeHeaders(HttpServletResponse response, Resource resource, long count) throws IOException {
        String contentType = this.servletContext.getMimeType(resource.getName());
        if (contentType != null) {
            response.setContentType(contentType);
        }
        if (count != -1L) {
            if (count < Integer.MAX_VALUE) {
                response.setContentLength((int)count);
            } else {
                response.setHeader("Content-Length", String.valueOf(count));
            }
        }
        response.setDateHeader("Last-Modified", resource.lastModified());
        response.setHeader("Cache-Control", CACHE_CONTROL_VALUE);
    }
}

