/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.tool.printers;

import com.google.cloud.sql.jdbc.internal.Util;
import com.google.cloud.sql.tool.printers.PrinterUtils;
import java.io.PrintWriter;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public abstract class Printer {
    private static final int DEFAULT_LOB_WIDTH = 1;
    protected static final int DEFAULT_DISPLAY_WIDTH = 256;
    protected final ResultSetMetaData md;
    protected final float elapsedSeconds;
    protected final PrintWriter out;
    protected final Map<Integer, Integer> columnWidths = Util.newHashMap();

    protected Printer(ResultSetMetaData md, float elapsedSeconds, PrintWriter out) {
        this.md = md;
        this.elapsedSeconds = elapsedSeconds;
        this.out = out;
        try {
            int numColumns = md.getColumnCount();
            for (int col = 1; col <= numColumns; ++col) {
                this.columnWidths.put(col, Printer.getDefaultColumnWidth(md, col));
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Unexpected Error Creating Printer", e);
        }
    }

    protected void displayHeader() throws SQLException {
    }

    public void displayFooter(int rowCount) throws SQLException {
    }

    protected abstract void displayLine(List<String> var1) throws SQLException;

    public void displayLines(List<List<String>> lines) throws SQLException {
        int numColumns = this.md.getColumnCount();
        for (List<String> row : lines) {
            this.updateColumnWidths(row, numColumns);
        }
        this.displayHeader();
        for (List<String> row : lines) {
            this.displayLine(row);
        }
    }

    private void updateColumnWidths(List<String> columns, int numColumns) {
        for (int col = 1; col <= numColumns; ++col) {
            int currentRow = PrinterUtils.nullOrText(columns.get(col - 1)).length();
            if (currentRow <= Util.getIntSafe(this.columnWidths.get(col))) continue;
            this.columnWidths.put(col, currentRow);
        }
    }

    private static int getDefaultColumnWidth(ResultSetMetaData md, int col) throws SQLException {
        int type;
        int size = PrinterUtils.nullOrText(md.getColumnLabel(col)).length();
        if (size == 0) {
            size = PrinterUtils.nullOrText(md.getColumnName(col)).length();
        }
        if (PrinterUtils.isString(type = md.getColumnType(col))) {
            return size;
        }
        if (PrinterUtils.isLobOrBinary(type)) {
            return Math.max(size, 1);
        }
        return Math.max(size, md.getColumnDisplaySize(col));
    }
}

