/**********************************************************************
Copyright (c) 2007 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.store.mapped.mapping;

import java.math.BigDecimal;

import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ClassNameConstants;
import org.datanucleus.store.mapped.expression.FloatingPointLiteral;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.NumericExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;

/**
 * Mapping for Number type.
 **/
public class NumberMapping extends SingleFieldMapping
{
	private static BigDecimal mappingSampleValue = new BigDecimal(0.0);

	public Object getSampleValue(ClassLoaderResolver clr)
	{
		return mappingSampleValue;
	}

    /**
     * Accessor for the name of the java-type actually used when mapping the particular datastore
     * field. This java-type must have an entry in the datastore mappings.
     * @param index requested datastore field index.
     * @return the name of java-type for the requested datastore field.
     */
    public String getJavaTypeForDatastoreMapping(int index)
    {
        // Assume it has the highest precision possible so we can store all subtypes of Number
        return ClassNameConstants.JAVA_MATH_BIGDECIMAL;
    }

    public Class getJavaType()
    {
        return Number.class;
    }

    public ScalarExpression newLiteral(QueryExpression qs, Object value)
    {
        return new FloatingPointLiteral(qs, (BigDecimal)value);
    }

    public ScalarExpression newScalarExpression(QueryExpression qs, LogicSetExpression te)
    {
        return new NumericExpression(qs, this, te);
    }
}