/**********************************************************************
Copyright (c) 2008 Andy Jefferson and others. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Contributors:
    ...
**********************************************************************/
package org.datanucleus.api.jpa;

import org.datanucleus.api.jpa.enhancement.ByteFieldPK;
import org.datanucleus.api.jpa.enhancement.CharFieldPK;
import org.datanucleus.api.jpa.enhancement.IntFieldPK;
import org.datanucleus.api.jpa.enhancement.LongFieldPK;
import org.datanucleus.api.jpa.enhancement.ObjectFieldPK;
import org.datanucleus.api.jpa.enhancement.Persistable;
import org.datanucleus.api.jpa.enhancement.ShortFieldPK;
import org.datanucleus.api.jpa.enhancement.StringFieldPK;


/**
 * Class providing names of common classes used by JPA to aid performance.
 */
public class JPAClassNameConstants
{
    /** org.datanucleus.identity.LongIdentity **/
    public static final String JPA_IDENTITY_LONG_IDENTITY = LongFieldPK.class.getName();

    /** org.datanucleus.identity.IntIdentity **/
    public static final String JPA_IDENTITY_INT_IDENTITY = IntFieldPK.class.getName();

    /** org.datanucleus.identity.StringIdentity **/
    public static final String JPA_IDENTITY_STRING_IDENTITY = StringFieldPK.class.getName();

    /** org.datanucleus.identity.CharIdentity **/
    public static final String JPA_IDENTITY_CHAR_IDENTITY = CharFieldPK.class.getName();

    /** org.datanucleus.identity.ByteIdentity **/
    public static final String JPA_IDENTITY_BYTE_IDENTITY = ByteFieldPK.class.getName();

    /** org.datanucleus.identity.ObjectIdentity **/
    public static final String JPA_IDENTITY_OBJECT_IDENTITY = ObjectFieldPK.class.getName();

    /** org.datanucleus.identity.ShortIdentity **/
    public static final String JPA_IDENTITY_SHORT_IDENTITY = ShortFieldPK.class.getName();

    /** org.datanucleus.api.jpa.Persistable **/
    public static final String JAVAX_JDO_SPI_PERSISTENCE_CAPABLE = Persistable.class.getName();
}
