/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer.asm;

import org.datanucleus.enhancer.ClassEnhancer;
import org.datanucleus.enhancer.ClassMethod;
import org.datanucleus.enhancer.DataNucleusEnhancer;
import org.datanucleus.enhancer.asm.ASMClassEnhancer;
import org.datanucleus.enhancer.asm.ASMUtils;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.util.Localiser;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JdoPropertyGetterAdapter
extends MethodVisitor {
    protected static Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.enhancer.Localisation", (ClassLoader)ClassEnhancer.class.getClassLoader());
    protected ASMClassEnhancer enhancer;
    protected String methodName;
    protected String methodDescriptor;
    protected AbstractMemberMetaData mmd;
    protected MethodVisitor jdoVisitor = null;

    public JdoPropertyGetterAdapter(MethodVisitor mv, ASMClassEnhancer enhancer, String methodName, String methodDesc, AbstractMemberMetaData mmd, ClassVisitor cv) {
        super(262144, mv);
        this.enhancer = enhancer;
        this.methodName = methodName;
        this.methodDescriptor = methodDesc;
        this.mmd = mmd;
        int access = (mmd.isPublic() ? 1 : 0) | (mmd.isProtected() ? 4 : 0) | (mmd.isPrivate() ? 2 : 0) | (mmd.isAbstract() ? 1024 : 0);
        this.jdoVisitor = cv.visitMethod(access, "jdoGet" + mmd.getName(), methodDesc, null, null);
    }

    public void visitEnd() {
        this.jdoVisitor.visitEnd();
        if (DataNucleusEnhancer.LOGGER.isDebugEnabled()) {
            String msg = ClassMethod.getMethodAdditionMessage("jdoGet" + this.mmd.getName(), this.mmd.getType(), null, null);
            DataNucleusEnhancer.LOGGER.debug((Object)LOCALISER.msg("Enhancer.AddMethod", (Object)msg));
        }
        if (!this.mmd.isAbstract()) {
            JdoPropertyGetterAdapter.generateGetXXXMethod(this.mv, this.mmd, this.enhancer.getASMClassName(), this.enhancer.getClassDescriptor());
        }
    }

    public static void generateGetXXXMethod(MethodVisitor mv, AbstractMemberMetaData mmd, String asmClassName, String asmClassDesc) {
        String[] argNames = new String[]{"objPC"};
        String fieldTypeDesc = Type.getDescriptor((Class)mmd.getType());
        mv.visitCode();
        AbstractClassMetaData cmd = mmd.getAbstractClassMetaData();
        if ((mmd.getJdoFieldFlag() & 2) == 2) {
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "Ljavax/jdo/spi/StateManager;");
            Label l1 = new Label();
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "Ljavax/jdo/spi/StateManager;");
            mv.visitVarInsn(25, 0);
            ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
            if (cmd.getPersistenceCapableSuperclass() != null) {
                mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                mv.visitInsn(96);
            }
            mv.visitMethodInsn(185, "javax/jdo/spi/StateManager", "isLoaded", "(Ljavax/jdo/spi/PersistenceCapable;I)Z");
            mv.visitJumpInsn(154, l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "Ljavax/jdo/spi/StateManager;");
            mv.visitVarInsn(25, 0);
            ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
            if (cmd.getPersistenceCapableSuperclass() != null) {
                mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                mv.visitInsn(96);
            }
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, asmClassName, "jdoGet" + mmd.getName(), "()" + fieldTypeDesc);
            String jdoMethodName = "get" + ASMUtils.getTypeNameForJDOMethod(mmd.getType()) + "Field";
            String argTypeDesc = fieldTypeDesc;
            if (jdoMethodName.equals("getObjectField")) {
                argTypeDesc = ASMUtils.CD_Object;
            }
            mv.visitMethodInsn(185, "javax/jdo/spi/StateManager", jdoMethodName, "(Ljavax/jdo/spi/PersistenceCapable;I" + argTypeDesc + ")" + argTypeDesc);
            if (jdoMethodName.equals("getObjectField")) {
                mv.visitTypeInsn(192, mmd.getTypeName().replace('.', '/'));
            }
            ASMUtils.addReturnForType(mv, mmd.getType());
            mv.visitLabel(l1);
            Label l4 = new Label();
            if (cmd.isDetachable()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, asmClassName, "jdoIsDetached", "()Z");
                mv.visitJumpInsn(153, l4);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, asmClassName, "jdoDetachedState", "[Ljava/lang/Object;");
                mv.visitInsn(5);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, "java/util/BitSet");
                ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
                if (cmd.getPersistenceCapableSuperclass() != null) {
                    mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                    mv.visitInsn(96);
                }
                mv.visitMethodInsn(182, "java/util/BitSet", "get", "(I)Z");
                mv.visitJumpInsn(154, l4);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, asmClassName, "jdoDetachedState", "[Ljava/lang/Object;");
                mv.visitInsn(6);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, "java/util/BitSet");
                ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
                if (cmd.getPersistenceCapableSuperclass() != null) {
                    mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                    mv.visitInsn(96);
                }
                mv.visitMethodInsn(182, "java/util/BitSet", "get", "(I)Z");
                mv.visitJumpInsn(154, l4);
                mv.visitTypeInsn(187, "javax/jdo/JDODetachedFieldAccessException");
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)LOCALISER.msg("Enhancer.DetachedPropertyAccess", (Object)mmd.getName()));
                mv.visitMethodInsn(183, "javax/jdo/JDODetachedFieldAccessException", "<init>", "(Ljava/lang/String;)V");
                mv.visitInsn(191);
            }
            mv.visitLabel(l4);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, asmClassName, "jdoGet" + mmd.getName(), "()" + fieldTypeDesc);
            ASMUtils.addReturnForType(mv, mmd.getType());
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            mv.visitLocalVariable(argNames[0], asmClassDesc, null, startLabel, endLabel, 0);
            mv.visitMaxs(4, 1);
        } else if ((mmd.getJdoFieldFlag() & 1) == 1) {
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoFlags", "B");
            Label l1 = new Label();
            mv.visitJumpInsn(158, l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "Ljavax/jdo/spi/StateManager;");
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "Ljavax/jdo/spi/StateManager;");
            mv.visitVarInsn(25, 0);
            ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
            if (cmd.getPersistenceCapableSuperclass() != null) {
                mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                mv.visitInsn(96);
            }
            mv.visitMethodInsn(185, "javax/jdo/spi/StateManager", "isLoaded", "(Ljavax/jdo/spi/PersistenceCapable;I)Z");
            mv.visitJumpInsn(154, l1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, asmClassName, "jdoStateManager", "Ljavax/jdo/spi/StateManager;");
            mv.visitVarInsn(25, 0);
            ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
            if (cmd.getPersistenceCapableSuperclass() != null) {
                mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                mv.visitInsn(96);
            }
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, asmClassName, "jdoGet" + mmd.getName(), "()" + fieldTypeDesc);
            String jdoMethodName = "get" + ASMUtils.getTypeNameForJDOMethod(mmd.getType()) + "Field";
            String argTypeDesc = fieldTypeDesc;
            if (jdoMethodName.equals("getObjectField")) {
                argTypeDesc = ASMUtils.CD_Object;
            }
            mv.visitMethodInsn(185, "javax/jdo/spi/StateManager", jdoMethodName, "(Ljavax/jdo/spi/PersistenceCapable;I" + argTypeDesc + ")" + argTypeDesc);
            if (jdoMethodName.equals("getObjectField")) {
                mv.visitTypeInsn(192, mmd.getTypeName().replace('.', '/'));
            }
            ASMUtils.addReturnForType(mv, mmd.getType());
            mv.visitLabel(l1);
            Label l4 = new Label();
            if (cmd.isDetachable()) {
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, asmClassName, "jdoIsDetached", "()Z");
                mv.visitJumpInsn(153, l4);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, asmClassName, "jdoDetachedState", "[Ljava/lang/Object;");
                mv.visitInsn(5);
                mv.visitInsn(50);
                mv.visitTypeInsn(192, "java/util/BitSet");
                ASMUtils.addBIPUSHToMethod(mv, mmd.getFieldId());
                if (cmd.getPersistenceCapableSuperclass() != null) {
                    mv.visitFieldInsn(178, asmClassName, "jdoInheritedFieldCount", "I");
                    mv.visitInsn(96);
                }
                mv.visitMethodInsn(182, "java/util/BitSet", "get", "(I)Z");
                mv.visitJumpInsn(154, l4);
                mv.visitTypeInsn(187, "javax/jdo/JDODetachedFieldAccessException");
                mv.visitInsn(89);
                mv.visitLdcInsn((Object)LOCALISER.msg("Enhancer.DetachedPropertyAccess", (Object)mmd.getName()));
                mv.visitMethodInsn(183, "javax/jdo/JDODetachedFieldAccessException", "<init>", "(Ljava/lang/String;)V");
                mv.visitInsn(191);
            }
            mv.visitLabel(l4);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, asmClassName, "jdoGet" + mmd.getName(), "()" + fieldTypeDesc);
            ASMUtils.addReturnForType(mv, mmd.getType());
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            mv.visitLocalVariable(argNames[0], asmClassDesc, null, startLabel, endLabel, 0);
            mv.visitMaxs(4, 1);
        } else {
            Label startLabel = new Label();
            mv.visitLabel(startLabel);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, asmClassName, "jdoGet" + mmd.getName(), "()" + fieldTypeDesc);
            ASMUtils.addReturnForType(mv, mmd.getType());
            Label endLabel = new Label();
            mv.visitLabel(endLabel);
            mv.visitLocalVariable(argNames[0], asmClassDesc, null, startLabel, endLabel, 0);
            mv.visitMaxs(1, 1);
        }
        mv.visitEnd();
    }

    public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
        return this.mv.visitAnnotation(arg0, arg1);
    }

    public AnnotationVisitor visitAnnotationDefault() {
        return this.jdoVisitor.visitAnnotationDefault();
    }

    public void visitAttribute(Attribute arg0) {
        this.jdoVisitor.visitAttribute(arg0);
    }

    public void visitCode() {
        this.jdoVisitor.visitCode();
    }

    public void visitFieldInsn(int arg0, String arg1, String arg2, String arg3) {
        this.jdoVisitor.visitFieldInsn(arg0, arg1, arg2, arg3);
    }

    public void visitFrame(int arg0, int arg1, Object[] arg2, int arg3, Object[] arg4) {
        this.jdoVisitor.visitFrame(arg0, arg1, arg2, arg3, arg4);
    }

    public void visitIincInsn(int arg0, int arg1) {
        this.jdoVisitor.visitIincInsn(arg0, arg1);
    }

    public void visitInsn(int arg0) {
        this.jdoVisitor.visitInsn(arg0);
    }

    public void visitIntInsn(int arg0, int arg1) {
        this.jdoVisitor.visitIntInsn(arg0, arg1);
    }

    public void visitJumpInsn(int arg0, Label arg1) {
        this.jdoVisitor.visitJumpInsn(arg0, arg1);
    }

    public void visitLabel(Label arg0) {
        this.jdoVisitor.visitLabel(arg0);
    }

    public void visitLdcInsn(Object arg0) {
        this.jdoVisitor.visitLdcInsn(arg0);
    }

    public void visitLineNumber(int arg0, Label arg1) {
        this.jdoVisitor.visitLineNumber(arg0, arg1);
    }

    public void visitLocalVariable(String arg0, String arg1, String arg2, Label arg3, Label arg4, int arg5) {
        this.jdoVisitor.visitLocalVariable(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public void visitLookupSwitchInsn(Label arg0, int[] arg1, Label[] arg2) {
        this.jdoVisitor.visitLookupSwitchInsn(arg0, arg1, arg2);
    }

    public void visitMaxs(int arg0, int arg1) {
        this.jdoVisitor.visitMaxs(arg0, arg1);
    }

    public void visitMethodInsn(int arg0, String arg1, String arg2, String arg3) {
        this.jdoVisitor.visitMethodInsn(arg0, arg1, arg2, arg3);
    }

    public void visitMultiANewArrayInsn(String arg0, int arg1) {
        this.jdoVisitor.visitMultiANewArrayInsn(arg0, arg1);
    }

    public AnnotationVisitor visitParameterAnnotation(int arg0, String arg1, boolean arg2) {
        return this.jdoVisitor.visitParameterAnnotation(arg0, arg1, arg2);
    }

    public void visitTableSwitchInsn(int arg0, int arg1, Label arg2, Label[] arg3) {
        this.jdoVisitor.visitTableSwitchInsn(arg0, arg1, arg2, arg3);
    }

    public void visitTryCatchBlock(Label arg0, Label arg1, Label arg2, String arg3) {
        this.jdoVisitor.visitTryCatchBlock(arg0, arg1, arg2, arg3);
    }

    public void visitTypeInsn(int arg0, String arg1) {
        this.jdoVisitor.visitTypeInsn(arg0, arg1);
    }

    public void visitVarInsn(int arg0, int arg1) {
        this.jdoVisitor.visitVarInsn(arg0, arg1);
    }
}

