/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.GenericApplication;
import com.google.appengine.tools.admin.ServerConnection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogFetcher {
    private static final String LOG_URL = "/api/request_logs";
    private static final String APP_ID_TAG = "app_id";
    private static final String MODULE_TAG = "module";
    private static final String VERSION_TAG = "version";
    private static final String LOG_LIMIT_TAG = "limit";
    private static final String LOG_LIMIT = "100";
    private static final String OFFSET_TAG = "offset";
    private static final String SEVERITY_TAG = "severity";
    private static final String INCLUDE_ALL_TAG = "include_all";
    private static final Pattern NEXTOFFSET_PATTERN = Pattern.compile("^#\\s*next_offset=(\\S+)\\s*$");
    private static final char NEWLINE = '\n';
    private ServerConnection connection;
    private GenericApplication app;

    public LogFetcher(GenericApplication app, ServerConnection connection) {
        this.app = app;
        this.connection = connection;
    }

    public void fetch(int numDays, AppAdmin.LogSeverity severity, boolean includeAll, OutputStream out) throws IOException {
        Date stopDate;
        PrintWriter writer = new PrintWriter(out);
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy", Locale.US);
        if (numDays > 0) {
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("America/Los_Angeles"), Locale.US);
            calendar.add(5, -numDays);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            stopDate = calendar.getTime();
        } else {
            stopDate = new Date(0L);
        }
        int recordCount = 0;
        this.app.statusUpdate("Beginning to retrieve log records...", 100);
        boolean moreLogs = true;
        String nextOffset = null;
        HashMap<String, String> httpArgs = new HashMap<String, String>();
        httpArgs.put(APP_ID_TAG, this.app.getAppId());
        if (this.app.getModule() != null) {
            httpArgs.put(MODULE_TAG, this.app.getModule());
        }
        httpArgs.put(VERSION_TAG, this.app.getVersion());
        httpArgs.put(LOG_LIMIT_TAG, LOG_LIMIT);
        if (severity != null) {
            httpArgs.put(SEVERITY_TAG, Integer.toString(severity.ordinal()));
        }
        if (includeAll) {
            httpArgs.put(INCLUDE_ALL_TAG, "True");
        }
        while (moreLogs) {
            String response = this.connection.get(LOG_URL, httpArgs);
            if (response.charAt(0) == '#') {
                String firstLine = response.substring(0, response.indexOf(10));
                Matcher matcher = NEXTOFFSET_PATTERN.matcher(firstLine);
                if (matcher.matches()) {
                    nextOffset = matcher.group(1);
                    httpArgs.put(OFFSET_TAG, nextOffset);
                }
                response = response.substring(response.indexOf(10) + 1);
            }
            if (response.lastIndexOf("\n#") > 0 || response.startsWith("#")) {
                response = response.substring(0, response.lastIndexOf("#"));
            }
            if (response.length() > 0) {
                int pos = 0;
                while (pos >= 0) {
                    String record;
                    Date recordDate;
                    int lastpos = pos;
                    if ((pos = response.indexOf(10, pos)) < 0) continue;
                    if ((recordDate = dateFormat.parse(record = response.substring(lastpos, ++pos), new ParsePosition(record.indexOf(91) + 1))).before(stopDate)) {
                        nextOffset = null;
                        break;
                    }
                    record = record.replace("\u0000", "\n\t");
                    writer.print(record);
                    ++recordCount;
                }
                int n = recordCount;
                this.app.statusUpdate(new StringBuilder(35).append("Received ").append(n).append(" log records...").toString());
            }
            moreLogs = nextOffset != null && response.length() > 0;
        }
        writer.close();
    }
}

