/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppVersionUpload;
import com.google.appengine.tools.admin.ClientDeploySender;
import com.google.appengine.tools.admin.HttpIoException;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.apphosting.utils.config.ClientDeployYamlMaker;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class LoggingClientDeploySender
implements ClientDeploySender {
    private static final Logger logger = Logger.getLogger(LoggingClientDeploySender.class.getName());
    private final ClientDeployYamlMaker maker;
    private final ServerConnection connection;

    LoggingClientDeploySender(ServerConnection connection, String sdkVersion) {
        long startTimeUsec = LoggingClientDeploySender.getCurrentTimeUsec();
        this.maker = new ClientDeployYamlMaker(startTimeUsec, sdkVersion);
        this.connection = connection;
    }

    @Override
    public String send(String url, File payload, String mimeType, String ... args) throws IOException {
        long startTimeUsec = LoggingClientDeploySender.getCurrentTimeUsec();
        try {
            String result = this.connection.post(url, payload, mimeType, args);
            this.registerHttpRequestForLogging(url, 200, startTimeUsec, payload.length());
            return result;
        }
        catch (HttpIoException e) {
            this.registerHttpRequestForLogging(url, e.getResponseCode(), startTimeUsec, payload.length());
            throw e;
        }
    }

    @Override
    public String send(String url, String payload, String ... args) throws IOException {
        long startTimeUsec = LoggingClientDeploySender.getCurrentTimeUsec();
        try {
            String result = this.connection.post(url, payload, args);
            this.registerHttpRequestForLogging(url, 200, startTimeUsec, payload.length());
            return result;
        }
        catch (HttpIoException e) {
            this.registerHttpRequestForLogging(url, e.getResponseCode(), startTimeUsec, payload.length());
            throw e;
        }
    }

    @Override
    public void sendBatch(String batchUrl, List<AppVersionUpload.FileInfo> batch, long batchSize, String ... args) throws IOException {
        long startTimeUsec = LoggingClientDeploySender.getCurrentTimeUsec();
        try {
            this.connection.post(batchUrl, batch, args);
            this.registerHttpRequestForLogging(batchUrl, 200, startTimeUsec, batchSize);
        }
        catch (HttpIoException e) {
            this.registerHttpRequestForLogging(batchUrl, e.getResponseCode(), startTimeUsec, batchSize);
            throw e;
        }
    }

    @Override
    public void logClientDeploy(boolean success, String ... args) {
        try {
            String yaml = this.maker.make(LoggingClientDeploySender.getCurrentTimeUsec(), success);
            logger.logp(Level.FINE, "com.google.appengine.tools.admin.LoggingClientDeploySender", "logClientDeploy", "client deploy yaml={0}", yaml);
            this.send("/api/logclientdeploy", yaml, args);
        }
        catch (Exception e) {
            logger.logp(Level.WARNING, "com.google.appengine.tools.admin.LoggingClientDeploySender", "logClientDeploy", "Error logging client deployment, continuing", e);
        }
    }

    @Override
    public String getRuntime() {
        return this.maker.getRuntime();
    }

    @Override
    public void setRuntime(String runtime) {
        this.maker.setRuntime(runtime);
    }

    @Override
    public String getSdkVersion() {
        return this.maker.getSdkVersion();
    }

    private void registerHttpRequestForLogging(String url, int httpResponseCode, long startTimeUsec, long requestLengthBytes) {
        this.maker.addRequest(url, httpResponseCode, startTimeUsec, LoggingClientDeploySender.getCurrentTimeUsec(), requestLengthBytes);
    }

    static long getCurrentTimeUsec() {
        return System.currentTimeMillis() * 1000L;
    }
}

