/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.time;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.time.TimeSource;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;

@GwtIncompatible
final class TimeSourceBasedClock
extends Clock
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final TimeSource timeSource;
    private final ZoneId zoneId;

    TimeSourceBasedClock(TimeSource timeSource, ZoneId zoneId) {
        this.timeSource = Preconditions.checkNotNull(timeSource);
        this.zoneId = Preconditions.checkNotNull(zoneId);
    }

    @Override
    public Instant instant() {
        return this.timeSource.now();
    }

    @Override
    public ZoneId getZone() {
        return this.zoneId;
    }

    @Override
    public Clock withZone(ZoneId newZoneId) {
        return new TimeSourceBasedClock(this.timeSource, newZoneId);
    }

    public String toString() {
        return String.format("%s.asClock(%s)", this.timeSource, this.zoneId);
    }
}

