/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.xml;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@GoogleInternal
@GwtIncompatible
public class ContentHandlerHelper
implements ContentHandler {
    protected ContentHandler ch;
    private final Attributes EMPTY_ATTS = new AttributesImpl();

    protected ContentHandlerHelper() {
    }

    public ContentHandlerHelper(ContentHandler ch, String nsURI, String nsPrefix) {
        this.ch = ch;
    }

    public ContentHandlerHelper(ContentHandler ch) {
        this(ch, "", "");
    }

    public static ContentHandlerHelper get(ContentHandler ch) {
        if (ch instanceof ContentHandlerHelper) {
            return (ContentHandlerHelper)ch;
        }
        return new ContentHandlerHelper(ch);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.ch.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        this.ch.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this.ch.endDocument();
    }

    @Override
    public void startElement(String nsUri, String lname, String qname, Attributes atts) throws SAXException {
        this.ch.startElement(nsUri, lname, qname, atts);
    }

    public void startElement(String s) throws SAXException {
        this.ch.startElement("", s, s, this.EMPTY_ATTS);
    }

    public void startElement(String s, Attributes atts) throws SAXException {
        this.ch.startElement("", s, s, atts);
    }

    @Override
    public void endElement(String nsUri, String lname, String qname) throws SAXException {
        this.ch.endElement(nsUri, lname, qname);
    }

    public void endElement(String s) throws SAXException {
        this.ch.endElement("", s, s);
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.ch.characters(chars, start, length);
    }

    public void characters(String s) throws SAXException {
        char[] chars = s.toCharArray();
        this.ch.characters(chars, 0, chars.length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.ch.processingInstruction(target, data);
    }

    @Override
    public void ignorableWhitespace(char[] chars, int start, int length) throws SAXException {
        this.ch.ignorableWhitespace(chars, start, length);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.ch.startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.ch.endPrefixMapping(prefix);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.ch.skippedEntity(name);
    }

    public void dataElement(String s, String v) throws SAXException {
        this.startElement(s);
        this.characters(v);
        this.endElement(s);
    }

    public void dataElement(String s, Attributes atts, String v) throws SAXException {
        this.startElement(s, atts);
        this.characters(v);
        this.endElement(s);
    }

    public void emptyElement(String s) throws SAXException {
        this.startElement(s);
        this.endElement(s);
    }

    public void emptyElement(String s, Attributes atts) throws SAXException {
        this.startElement(s, atts);
        this.endElement(s);
    }

    public void emptyElement(String nsUri, String lname, String qname, Attributes atts) throws SAXException {
        this.ch.startElement(nsUri, lname, qname, atts);
        this.ch.endElement(nsUri, lname, qname);
    }

    public void emptyElement(String nsUri, String lname, String qname) throws SAXException {
        this.ch.startElement(nsUri, lname, qname, this.EMPTY_ATTS);
        this.ch.endElement(nsUri, lname, qname);
    }
}

