/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.xml;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.xml.ContentHandlerHelper;
import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import java.io.IOException;
import java.io.Writer;
import org.xml.sax.SAXException;

@GoogleInternal
@GwtIncompatible
public final class XmlGenerator
extends ContentHandlerHelper {
    private final XMLSerializer serializer;

    public XmlGenerator(Writer out) throws SAXException, IOException {
        this(out, null, false, true, null, null);
    }

    public XmlGenerator(Writer out, String encoding) throws SAXException, IOException {
        this(out, encoding, false, true, null, null);
    }

    public XmlGenerator(Writer out, boolean indenting) throws SAXException, IOException {
        this(out, null, indenting, true, null, null);
    }

    public XmlGenerator(Writer out, String encoding, boolean indenting) throws SAXException, IOException {
        this(out, encoding, indenting, true, null, null);
    }

    public XmlGenerator(Writer out, String encoding, boolean indenting, boolean omitsXMLDeclaration) throws SAXException, IOException {
        this(out, encoding, indenting, omitsXMLDeclaration, null, null);
    }

    public XmlGenerator(Writer out, String encoding, boolean indenting, boolean omitsXMLDeclaration, String publicDoctype, String systemDoctype) throws SAXException, IOException {
        OutputFormat fmt = new OutputFormat();
        fmt.setOmitXMLDeclaration(omitsXMLDeclaration);
        if (encoding != null) {
            fmt.setEncoding(encoding);
        }
        fmt.setIndenting(indenting);
        if (publicDoctype != null || systemDoctype != null) {
            fmt.setOmitDocumentType(false);
            fmt.setDoctype(publicDoctype, systemDoctype);
        }
        this.serializer = new XMLSerializer(out, fmt);
        this.ch = this.serializer.asContentHandler();
        this.ch.startDocument();
    }

    public XMLSerializer getXmlSerializer() {
        return this.serializer;
    }
}

