/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.tz;

import com.google.appengine.repackaged.org.joda.time.DateTimeZone;
import com.google.appengine.repackaged.org.joda.time.tz.DateTimeZoneBuilder;
import com.google.appengine.repackaged.org.joda.time.tz.Provider;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class ZoneInfoProvider
implements Provider {
    private final File iFileDir;
    private final String iResourcePath;
    private final ClassLoader iLoader;
    private final Map<String, Object> iZoneInfoMap;

    public ZoneInfoProvider(File fileDir) throws IOException {
        if (fileDir == null) {
            throw new IllegalArgumentException("No file directory provided");
        }
        if (!fileDir.exists()) {
            String string = String.valueOf(fileDir);
            throw new IOException(new StringBuilder(30 + String.valueOf(string).length()).append("File directory doesn't exist: ").append(string).toString());
        }
        if (!fileDir.isDirectory()) {
            String string = String.valueOf(fileDir);
            throw new IOException(new StringBuilder(35 + String.valueOf(string).length()).append("File doesn't refer to a directory: ").append(string).toString());
        }
        this.iFileDir = fileDir;
        this.iResourcePath = null;
        this.iLoader = null;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    public ZoneInfoProvider(String resourcePath) throws IOException {
        this(resourcePath, null, false);
    }

    public ZoneInfoProvider(String resourcePath, ClassLoader loader) throws IOException {
        this(resourcePath, loader, true);
    }

    private ZoneInfoProvider(String resourcePath, ClassLoader loader, boolean favorSystemLoader) throws IOException {
        if (resourcePath == null) {
            throw new IllegalArgumentException("No resource path provided");
        }
        if (!resourcePath.endsWith("/")) {
            String string = String.valueOf(resourcePath);
            resourcePath = new StringBuilder(1 + String.valueOf(string).length()).append(string).append('/').toString();
        }
        this.iFileDir = null;
        this.iResourcePath = resourcePath;
        if (loader == null && !favorSystemLoader) {
            loader = this.getClass().getClassLoader();
        }
        this.iLoader = loader;
        this.iZoneInfoMap = ZoneInfoProvider.loadZoneInfoMap(this.openResource("ZoneInfoMap"));
    }

    @Override
    public DateTimeZone getZone(String id) {
        if (id == null) {
            return null;
        }
        Object obj = this.iZoneInfoMap.get(id);
        if (obj == null) {
            return null;
        }
        if (id.equals(obj)) {
            return this.loadZoneData(id);
        }
        if (obj instanceof SoftReference) {
            SoftReference ref = (SoftReference)obj;
            DateTimeZone tz = (DateTimeZone)ref.get();
            if (tz != null) {
                return tz;
            }
            return this.loadZoneData(id);
        }
        return this.getZone((String)obj);
    }

    @Override
    public Set<String> getAvailableIDs() {
        return new TreeSet<String>(this.iZoneInfoMap.keySet());
    }

    protected void uncaughtException(Exception ex) {
        Thread t = Thread.currentThread();
        t.getThreadGroup().uncaughtException(t, ex);
    }

    private InputStream openResource(String name) throws IOException {
        InputStream in;
        if (this.iFileDir != null) {
            in = new FileInputStream(new File(this.iFileDir, name));
        } else {
            String path = this.iResourcePath.concat(name);
            in = this.iLoader != null ? this.iLoader.getResourceAsStream(path) : ClassLoader.getSystemResourceAsStream(path);
            if (in == null) {
                StringBuilder buf = new StringBuilder(40).append("Resource not found: \"").append(path).append("\" ClassLoader: ").append(this.iLoader != null ? this.iLoader.toString() : "system");
                throw new IOException(buf.toString());
            }
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DateTimeZone loadZoneData(String id) {
        InputStream in = null;
        try {
            in = this.openResource(id);
            DateTimeZone tz = DateTimeZoneBuilder.readFrom(in, id);
            this.iZoneInfoMap.put(id, new SoftReference<DateTimeZone>(tz));
            DateTimeZone dateTimeZone = tz;
            return dateTimeZone;
        }
        catch (IOException ex) {
            this.uncaughtException(ex);
            this.iZoneInfoMap.remove(id);
            DateTimeZone dateTimeZone = null;
            return dateTimeZone;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> loadZoneInfoMap(InputStream in) throws IOException {
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        DataInputStream din = new DataInputStream(in);
        try {
            ZoneInfoProvider.readZoneInfoMap(din, map);
        }
        finally {
            try {
                din.close();
            }
            catch (IOException iOException) {}
        }
        map.put("UTC", new SoftReference<DateTimeZone>(DateTimeZone.UTC));
        return map;
    }

    private static void readZoneInfoMap(DataInputStream din, Map<String, Object> zimap) throws IOException {
        int i;
        int size = din.readUnsignedShort();
        String[] pool = new String[size];
        for (i = 0; i < size; ++i) {
            pool[i] = din.readUTF().intern();
        }
        size = din.readUnsignedShort();
        for (i = 0; i < size; ++i) {
            try {
                zimap.put(pool[din.readUnsignedShort()], pool[din.readUnsignedShort()]);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new IOException("Corrupt zone info map");
            }
        }
    }
}

