/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.labs.datastore.overlay.NamespacePinnedAsyncDatastoreServiceImpl;
import com.google.appengine.api.labs.datastore.overlay.QueryResultBatchIterator;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import java.util.List;

final class NamespacePinnedQueryResultIteratorImpl
implements QueryResultBatchIterator<Entity> {
    private final NamespacePinnedAsyncDatastoreServiceImpl datastore;
    private final QueryResultIterator<Entity> iterator;

    public NamespacePinnedQueryResultIteratorImpl(NamespacePinnedAsyncDatastoreServiceImpl datastore, QueryResultIterator<Entity> iterator) {
        this.datastore = Preconditions.checkNotNull(datastore);
        this.iterator = Preconditions.checkNotNull(iterator);
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Entity next() {
        return this.datastore.getOriginalNamespaceEntity((Entity)this.iterator.next());
    }

    @Override
    public List<Entity> nextList(int maximumElements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < maximumElements && this.hasNext(); ++i) {
            builder.add(this.datastore.getOriginalNamespaceEntity(this.next()));
        }
        return builder.build();
    }

    public List<Index> getIndexList() {
        return this.iterator.getIndexList();
    }

    public Cursor getCursor() {
        return this.iterator.getCursor();
    }

    public void remove() {
        this.iterator.remove();
    }
}

