/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.state;

import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.cache.CachedPC;
import org.datanucleus.exceptions.ClassNotResolvedException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.state.JDOStateManager;
import org.datanucleus.state.StateManager;
import org.datanucleus.store.ExecutionContext;
import org.datanucleus.store.FieldValues;
import org.datanucleus.store.ObjectProvider;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.Localiser;

public class StateManagerFactory {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);

    public ObjectProvider newForHollow(ExecutionContext ec, Class pcClass, Object id) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pcClass);
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollow(id, null, stateManagerInitialization.getPCClass());
        return sm;
    }

    public ObjectProvider newForHollowPreConstructed(ExecutionContext ec, Object id, Object pc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollowPreConstructed(id, pc);
        return sm;
    }

    public ObjectProvider newForHollowPopulated(ExecutionContext ec, Class pcClass, Object id, FieldValues fv) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pcClass);
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollow(id, fv, stateManagerInitialization.getPCClass());
        return sm;
    }

    public ObjectProvider newForPersistentClean(ExecutionContext ec, Object id, Object pc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPersistentClean(id, pc);
        return sm;
    }

    public ObjectProvider newForHollowPopulatedAppId(ExecutionContext ec, Class pcClass, FieldValues fv) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pcClass);
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForHollowAppId(fv, stateManagerInitialization.getPCClass());
        return sm;
    }

    public ObjectProvider newForEmbedded(ExecutionContext ec, Object pc, boolean copyPc, ObjectProvider ownerOP, int ownerFieldNumber) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForEmbedded(pc, copyPc);
        if (ownerOP != null) {
            sm.addEmbeddedOwner(ownerOP, ownerFieldNumber);
        }
        return sm;
    }

    public ObjectProvider newForEmbedded(ExecutionContext ec, AbstractClassMetaData cmd, ObjectProvider ownerOP, int ownerFieldNumber) {
        Class pcClass = ec.getClassLoaderResolver().classForName(cmd.getFullClassName());
        StateManager sm = (StateManager)this.newForHollow(ec, pcClass, null);
        sm.initialiseForEmbedded(sm.getObject(), false);
        if (ownerOP != null) {
            sm.addEmbeddedOwner(ownerOP, ownerFieldNumber);
        }
        return sm;
    }

    public ObjectProvider newForPersistentNew(ExecutionContext ec, Object pc, FieldValues preInsertChanges) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPersistentNew(pc, preInsertChanges);
        return sm;
    }

    public ObjectProvider newForTransactionalTransient(ExecutionContext ec, Object pc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForTransactionalTransient(pc);
        return sm;
    }

    public ObjectProvider newForDetached(ExecutionContext ec, Object pc, Object id, Object version) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForDetached(pc, id, version);
        return sm;
    }

    public ObjectProvider newForPNewToBeDeleted(ExecutionContext ec, Object pc) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), pc.getClass());
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForPNewToBeDeleted(pc);
        return sm;
    }

    public ObjectProvider newForCachedPC(ExecutionContext ec, Object id, CachedPC cachedPC) {
        Initialization stateManagerInitialization = new Initialization(ec.getClassLoaderResolver(), ec.getMetaDataManager(), cachedPC.getObjectClass());
        StateManager sm = this.newStateManager(ec, stateManagerInitialization.getClassMetaData());
        sm.initialiseForCachedPC(cachedPC, id, stateManagerInitialization.getPCClass());
        return sm;
    }

    StateManager newStateManager(ExecutionContext ec, AbstractClassMetaData acmd) {
        return new JDOStateManager(ec, acmd);
    }

    protected static class Initialization {
        protected Class pcClass;
        protected AbstractClassMetaData cmd;

        protected Initialization(ClassLoaderResolver clr, MetaDataManager mmgr, Class pcClass) {
            if (ClassUtils.isReferenceType(pcClass)) {
                this.cmd = mmgr.getMetaDataForImplementationOfReference(pcClass, null, clr);
                this.pcClass = clr.classForName(this.cmd.getFullClassName(), pcClass.getClassLoader(), true);
            } else {
                try {
                    this.pcClass = clr.classForName(pcClass.getName(), pcClass.getClassLoader(), true);
                    this.cmd = mmgr.getMetaDataForClass(pcClass, clr);
                }
                catch (ClassNotResolvedException e) {
                    throw new NucleusUserException(LOCALISER.msg("026015", (Object)pcClass.getName())).setFatal();
                }
            }
            if (this.cmd == null) {
                throw new NucleusUserException(LOCALISER.msg("026012", pcClass)).setFatal();
            }
        }

        protected Class getPCClass() {
            return this.pcClass;
        }

        protected AbstractClassMetaData getClassMetaData() {
            return this.cmd;
        }
    }
}

