/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.MonitoredIndexUsageTracker;
import com.google.appengine.api.datastore.PostLoadContext;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

abstract class BaseQueryResultsSource<InitialResultT, NextRequestT, NextResultT>
implements QueryResultsSource {
    static Logger logger = Logger.getLogger(BaseQueryResultsSource.class.getName());
    private static final int AT_LEAST_ONE = -1;
    private static final String DISABLE_CHUNK_SIZE_WARNING_SYS_PROP = "appengine.datastore.disableChunkSizeWarning";
    private static final int CHUNK_SIZE_WARNING_RESULT_SET_SIZE_THRESHOLD = 1000;
    private static final long MAX_CHUNK_SIZE_WARNING_FREQUENCY_MS = 300000L;
    static MonitoredIndexUsageTracker monitoredIndexUsageTracker = new MonitoredIndexUsageTracker();
    static final AtomicLong lastChunkSizeWarning = new AtomicLong(0L);
    private final DatastoreCallbacks callbacks;
    private final int chunkSize;
    private final int offset;
    private final Transaction txn;
    private final Query query;
    private final CurrentTransactionProvider currentTransactionProvider;
    private Future<NextResultT> queryResultFuture = null;
    private int skippedResults;
    private int totalResults = 0;
    private List<Index> indexList = null;
    private boolean addedSkippedCursor;
    private final Future<InitialResultT> initialQueryResultFuture;
    private NextRequestT nextQueryPrototype = null;

    public BaseQueryResultsSource(DatastoreCallbacks callbacks, FetchOptions fetchOptions, final Transaction txn, Query query, Future<InitialResultT> initialQueryResultFuture) {
        this.callbacks = callbacks;
        this.chunkSize = fetchOptions.getChunkSize() != null ? fetchOptions.getChunkSize() : -1;
        this.offset = fetchOptions.getOffset() != null ? fetchOptions.getOffset() : 0;
        this.txn = txn;
        this.query = query;
        this.currentTransactionProvider = new CurrentTransactionProvider(this){

            @Override
            public Transaction getCurrentTransaction(Transaction defaultValue) {
                return txn;
            }
        };
        this.initialQueryResultFuture = initialQueryResultFuture;
        this.skippedResults = 0;
    }

    abstract WrappedQueryResult wrapInitialResult(InitialResultT var1);

    abstract WrappedQueryResult wrapResult(NextResultT var1);

    abstract NextRequestT buildNextCallPrototype(InitialResultT var1);

    abstract Future<NextResultT> makeNextCall(NextRequestT var1, WrappedQueryResult var2, Integer var3, Integer var4);

    @Override
    public boolean hasMoreEntities() {
        return this.nextQueryPrototype == null || this.queryResultFuture != null;
    }

    @Override
    public int getNumSkipped() {
        return this.skippedResults;
    }

    @Override
    public List<Index> getIndexList() {
        if (this.indexList == null) {
            InitialResultT res = FutureHelper.quietGet(this.initialQueryResultFuture);
            HashSet<Index> monitoredIndexBuffer = Sets.newHashSet();
            this.indexList = this.wrapInitialResult(res).getIndexInfo(monitoredIndexBuffer);
            if (!monitoredIndexBuffer.isEmpty()) {
                monitoredIndexUsageTracker.addNewUsage(monitoredIndexBuffer, this.query);
            }
        }
        return this.indexList;
    }

    @Override
    public Cursor loadMoreEntities(List<Entity> buffer, List<Cursor> cursorBuffer) {
        return this.loadMoreEntities(-1, buffer, cursorBuffer);
    }

    @Override
    public Cursor loadMoreEntities(int numberToLoad, List<Entity> buffer, List<Cursor> cursorBuffer) {
        WrappedQueryResult res;
        TransactionImpl.ensureTxnActive(this.txn);
        if (!this.hasMoreEntities()) {
            return null;
        }
        if (numberToLoad == 0 && this.offset <= this.skippedResults) {
            if (!this.addedSkippedCursor) {
                cursorBuffer.add(null);
                this.addedSkippedCursor = true;
            }
            return null;
        }
        if (this.nextQueryPrototype == null) {
            this.getIndexList();
            InitialResultT initialRes = FutureHelper.quietGet(this.initialQueryResultFuture);
            this.nextQueryPrototype = this.buildNextCallPrototype(initialRes);
            res = this.wrapInitialResult(initialRes);
        } else {
            res = this.wrapResult(FutureHelper.quietGet(this.queryResultFuture));
            this.queryResultFuture = null;
        }
        int fetchedSoFar = this.processQueryResult(res, buffer, cursorBuffer);
        Integer fetchCountOrNull = null;
        Integer offsetOrNull = null;
        if (res.hasMoreResults()) {
            boolean setCount = true;
            if (numberToLoad <= 0) {
                setCount = false;
                if (this.chunkSize != -1) {
                    fetchCountOrNull = this.chunkSize;
                }
                if (numberToLoad == -1) {
                    numberToLoad = 1;
                }
            }
            while (res.hasMoreResults() && (this.skippedResults < this.offset || fetchedSoFar < numberToLoad)) {
                WrappedQueryResult nextRes;
                offsetOrNull = this.skippedResults < this.offset ? Integer.valueOf(this.offset - this.skippedResults) : null;
                if (setCount) {
                    fetchCountOrNull = Math.max(this.chunkSize, numberToLoad - fetchedSoFar);
                }
                if (!(nextRes = this.wrapResult(FutureHelper.quietGet(this.makeNextCall(this.nextQueryPrototype, res, fetchCountOrNull, offsetOrNull)))).madeProgress(res)) {
                    throw new DatastoreTimeoutException("The query was not able to make any progress.");
                }
                res = nextRes;
                fetchedSoFar += this.processQueryResult(res, buffer, cursorBuffer);
            }
        }
        if (res.hasMoreResults()) {
            fetchCountOrNull = this.chunkSize != -1 ? Integer.valueOf(this.chunkSize) : null;
            offsetOrNull = null;
            this.queryResultFuture = this.makeNextCall(this.nextQueryPrototype, res, fetchCountOrNull, offsetOrNull);
        }
        return res.getEndCursor();
    }

    private int processQueryResult(WrappedQueryResult res, List<Entity> buffer, List<Cursor> cursorBuffer) {
        this.skippedResults += res.numSkippedResults();
        if (this.skippedResults >= this.offset && !this.addedSkippedCursor) {
            cursorBuffer.add(res.getSkippedResultsCursor());
            this.addedSkippedCursor = true;
        }
        List<Entity> entityList = res.getEntities(this.query.getProjections());
        buffer.addAll(entityList);
        cursorBuffer.addAll(res.getResultCursors());
        for (Entity entity : entityList) {
            this.callbacks.executePostLoadCallbacks(new PostLoadContext(this.currentTransactionProvider, entity));
        }
        this.totalResults += entityList.size();
        if (this.chunkSize == -1 && this.totalResults > 1000 && System.getProperty(DISABLE_CHUNK_SIZE_WARNING_SYS_PROP) == null) {
            this.logChunkSizeWarning();
        }
        return entityList.size();
    }

    void logChunkSizeWarning() {
        long now = System.currentTimeMillis();
        if (now - lastChunkSizeWarning.get() < 300000L) {
            return;
        }
        logger.warning("This query does not have a chunk size set in FetchOptions and has returned over 1000 results.  If result sets of this size are common for this query, consider setting a chunk size to improve performance.\n  To disable this warning set the following system property in appengine-web.xml (the value of the property doesn't matter): 'appengine.datastore.disableChunkSizeWarning'");
        lastChunkSizeWarning.set(now);
    }

    static interface WrappedQueryResult {
        public Cursor getEndCursor();

        public List<Entity> getEntities(Collection<Projection> var1);

        public List<Cursor> getResultCursors();

        public Cursor getSkippedResultsCursor();

        public boolean hasMoreResults();

        public int numSkippedResults();

        public List<Index> getIndexInfo(Collection<Index> var1);

        public boolean madeProgress(WrappedQueryResult var1);
    }
}

