/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.AbstractModule;
import com.google.appengine.tools.development.ApplicationConfigurationManager;
import com.google.appengine.tools.development.AutomaticModule;
import com.google.appengine.tools.development.BasicModule;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.InstanceHolder;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.ManualModule;
import com.google.appengine.tools.development.Module;
import com.google.appengine.tools.development.ModulesController;
import com.google.appengine.tools.development.ModulesFilterHelper;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.AppEngineWebXml;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Modules
implements ModulesController,
ModulesFilterHelper {
    private static final AtomicReference<Modules> instance = new AtomicReference();
    private static final Logger LOGGER = Logger.getLogger(Modules.class.getName());
    private final List<Module> modules;
    private final Map<String, Module> moduleNameToModuleMap;
    private final Lock dynamicConfigurationLock = new ReentrantLock();
    private static final int DYNAMIC_CONFIGURATION_TIMEOUT_SECONDS = 2;

    public static Modules createModules(ApplicationConfigurationManager applicationConfigurationManager, String serverInfo, File externalResourceDir, String address, DevAppServer devAppServer) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ApplicationConfigurationManager.ModuleConfigurationHandle moduleConfigurationHandle : applicationConfigurationManager.getModuleConfigurationHandles()) {
            AppEngineWebXml appEngineWebXml = moduleConfigurationHandle.getModule().getAppEngineWebXml();
            AbstractModule module = null;
            module = !appEngineWebXml.getBasicScaling().isEmpty() ? new BasicModule(moduleConfigurationHandle, serverInfo, address, devAppServer, appEngineWebXml) : (!appEngineWebXml.getManualScaling().isEmpty() ? new ManualModule(moduleConfigurationHandle, serverInfo, address, devAppServer, appEngineWebXml) : new AutomaticModule(moduleConfigurationHandle, serverInfo, externalResourceDir, address, devAppServer));
            builder.add(module);
            externalResourceDir = null;
        }
        instance.set(new Modules((List<Module>)((Object)builder.build())));
        return instance.get();
    }

    public static Modules getInstance() {
        return instance.get();
    }

    public void shutdown() throws Exception {
        for (Module module : this.modules) {
            module.shutdown();
        }
    }

    public void configure(Map<String, Object> containerConfigProperties) throws Exception {
        for (Module module : this.modules) {
            module.configure(containerConfigProperties);
        }
    }

    public void setApiProxyDelegate(ApiProxy.Delegate<?> apiProxyDelegate) {
        for (Module module : this.modules) {
            module.setApiProxyDelegate(apiProxyDelegate);
        }
    }

    public void createConnections() throws Exception {
        for (Module module : this.modules) {
            module.createConnection();
        }
    }

    public void startup() throws Exception {
        for (Module module : this.modules) {
            module.startup();
        }
    }

    public Module getMainModule() {
        return this.modules.get(0);
    }

    private Modules(List<Module> modules) {
        if (modules.size() < 1) {
            throw new IllegalArgumentException("modules must not be empty.");
        }
        this.modules = modules;
        ImmutableMap.Builder<String, Module> mapBuilder = ImmutableMap.builder();
        for (Module module : this.modules) {
            mapBuilder.put(module.getModuleName(), module);
        }
        this.moduleNameToModuleMap = mapBuilder.build();
    }

    public LocalServerEnvironment getLocalServerEnvironment() {
        return this.modules.get(0).getLocalServerEnvironment();
    }

    public Module getModule(String moduleName) {
        return this.moduleNameToModuleMap.get(moduleName);
    }

    @Override
    public Iterable<String> getModuleNames() {
        return this.moduleNameToModuleMap.keySet();
    }

    @Override
    public Iterable<String> getVersions(String moduleName) throws ApiProxy.ApplicationException {
        return ImmutableList.of(this.getDefaultVersion(moduleName));
    }

    @Override
    public String getDefaultVersion(String moduleName) throws ApiProxy.ApplicationException {
        Module module = this.getRequiredModule(moduleName);
        return module.getMainContainer().getAppEngineWebXmlConfig().getMajorVersionId();
    }

    @Override
    public int getNumInstances(String moduleName, String version) throws ApiProxy.ApplicationException {
        Module module = this.getRequiredModule(moduleName);
        this.checkVersion(version, module);
        AppEngineWebXml.ManualScaling manualScaling = this.getRequiredManualScaling(module);
        return Integer.parseInt(manualScaling.getInstances());
    }

    @Override
    public void setNumInstances(String moduleName, String version, int numInstances) throws ApiProxy.ApplicationException {
        throw new UnsupportedOperationException("ModulesService.setNumInstances not currently supported by java dev appserver");
    }

    @Override
    public String getHostname(String moduleName, String version, int instance) throws ApiProxy.ApplicationException {
        String hostAndPort;
        Module module = this.getRequiredModule(moduleName);
        if (instance != -1) {
            this.checkVersion(version, module);
            this.checkNotDynamicModule(module);
        }
        if ((hostAndPort = module.getHostAndPort(instance)) == null) {
            throw new ApiProxy.ApplicationException(3, new StringBuilder(30).append("Instance ").append(instance).append(" not found").toString());
        }
        return hostAndPort;
    }

    @Override
    public ModulesController.ModuleState getModuleState(String moduleName) throws ApiProxy.ApplicationException {
        return this.checkModuleStopped(moduleName) ? ModulesController.ModuleState.STOPPED : ModulesController.ModuleState.RUNNING;
    }

    @Override
    public String getScalingType(String moduleName) throws ApiProxy.ApplicationException {
        Module module = this.getModule(moduleName);
        if (module == null) {
            return null;
        }
        return module.getClass().getSimpleName();
    }

    @Override
    public void startModule(final String moduleName, final String version) throws ApiProxy.ApplicationException {
        this.doDynamicConfiguration("startServing", new Runnable(){

            @Override
            public void run() {
                Modules.this.doStartModule(moduleName, version);
            }
        });
    }

    private void doStartModule(String moduleName, String version) {
        Module module = this.getRequiredModule(moduleName);
        this.checkVersion(version, module);
        this.checkNotDynamicModule(module);
        try {
            module.startServing();
        }
        catch (Exception e) {
            LOGGER.logp(Level.SEVERE, "com.google.appengine.tools.development.Modules", "doStartModule", "startServing failed", e);
            String string = String.valueOf(e.getMessage());
            throw new ApiProxy.ApplicationException(5, string.length() != 0 ? "startServing failed with error ".concat(string) : new String("startServing failed with error "));
        }
    }

    @Override
    public void stopModule(final String moduleName, final String version) throws ApiProxy.ApplicationException {
        this.doDynamicConfiguration("stopServing", new Runnable(){

            @Override
            public void run() {
                Modules.this.doStopModule(moduleName, version);
            }
        });
    }

    private void doDynamicConfiguration(String operation, Runnable runnable) {
        block6: {
            try {
                if (this.dynamicConfigurationLock.tryLock(2L, TimeUnit.SECONDS)) {
                    try {
                        runnable.run();
                        break block6;
                    }
                    finally {
                        this.dynamicConfigurationLock.unlock();
                    }
                }
                LOGGER.logp(Level.SEVERE, "com.google.appengine.tools.development.Modules", "doDynamicConfiguration", "stopServing timed out");
                throw new ApiProxy.ApplicationException(5, String.valueOf(operation).concat(" timed out"));
            }
            catch (InterruptedException ie) {
                LOGGER.logp(Level.SEVERE, "com.google.appengine.tools.development.Modules", "doDynamicConfiguration", "stopServing interrupted", ie);
                String string = ie.getMessage();
                throw new ApiProxy.ApplicationException(5, new StringBuilder(13 + String.valueOf(operation).length() + String.valueOf(string).length()).append(operation).append(" interrupted ").append(string).toString());
            }
        }
    }

    private void doStopModule(String moduleName, String version) {
        Module module = this.getRequiredModule(moduleName);
        this.checkVersion(version, module);
        this.checkNotDynamicModule(module);
        try {
            module.stopServing();
        }
        catch (Exception e) {
            LOGGER.logp(Level.SEVERE, "com.google.appengine.tools.development.Modules", "doStopModule", "stopServing failed", e);
            String string = String.valueOf(e.getMessage());
            throw new ApiProxy.ApplicationException(5, string.length() != 0 ? "stopServing failed with error ".concat(string) : new String("stopServing failed with error "));
        }
    }

    private Module getRequiredModule(String moduleName) {
        Module module = this.moduleNameToModuleMap.get(moduleName);
        if (module == null) {
            throw new ApiProxy.ApplicationException(1, "Module not found");
        }
        return module;
    }

    private void checkNotDynamicModule(Module module) {
        if (module.getMainContainer().getAppEngineWebXmlConfig().getManualScaling().isEmpty() && module.getMainContainer().getAppEngineWebXmlConfig().getBasicScaling().isEmpty()) {
            String string = module.getModuleName();
            LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.Modules", "checkNotDynamicModule", new StringBuilder(34 + String.valueOf(string).length()).append("Module ").append(string).append(" cannot be a dynamic module").toString());
            throw new ApiProxy.ApplicationException(2, "This operation is not supported on Dynamic modules.");
        }
    }

    private AppEngineWebXml.ManualScaling getRequiredManualScaling(Module module) {
        AppEngineWebXml.ManualScaling manualScaling = module.getMainContainer().getAppEngineWebXmlConfig().getManualScaling();
        if (manualScaling.isEmpty()) {
            String string = module.getModuleName();
            LOGGER.logp(Level.WARNING, "com.google.appengine.tools.development.Modules", "getRequiredManualScaling", new StringBuilder(39 + String.valueOf(string).length()).append("Module ").append(string).append(" must be a manual scaling module").toString());
            throw new ApiProxy.ApplicationException(2, "Manual scaling is required.");
        }
        return manualScaling;
    }

    private void checkVersion(String version, Module module) {
        String moduleVersion = module.getMainContainer().getAppEngineWebXmlConfig().getMajorVersionId();
        if (version == null || !version.equals(moduleVersion)) {
            throw new ApiProxy.ApplicationException(2, "Version not found");
        }
    }

    @Override
    public boolean acquireServingPermit(String moduleName, int instanceNumber, boolean allowQueueOnBackends) {
        Module module = this.getModule(moduleName);
        InstanceHolder instanceHolder = module.getInstanceHolder(instanceNumber);
        return instanceHolder.acquireServingPermit();
    }

    @Override
    public int getAndReserveFreeInstance(String moduleName) {
        Module module = this.getModule(moduleName);
        InstanceHolder instanceHolder = module.getAndReserveAvailableInstanceHolder();
        return instanceHolder == null ? -1 : instanceHolder.getInstance();
    }

    @Override
    public void returnServingPermit(String moduleName, int instance) {
    }

    @Override
    public boolean checkInstanceExists(String moduleName, int instance) {
        Module module = this.getModule(moduleName);
        return module != null && module.getInstanceHolder(instance) != null;
    }

    @Override
    public boolean checkModuleExists(String moduleName) {
        return this.getModule(moduleName) != null;
    }

    @Override
    public boolean checkModuleStopped(String serverName) {
        return this.checkInstanceStopped(serverName, -1);
    }

    @Override
    public boolean checkInstanceStopped(String moduleName, int instance) {
        Module module = this.getModule(moduleName);
        InstanceHolder instanceHolder = module.getInstanceHolder(instance);
        return instanceHolder.isStopped();
    }

    @Override
    public void forwardToInstance(String requestedModule, int instance, HttpServletRequest hrequest, HttpServletResponse hresponse) throws IOException, ServletException {
        Module module = this.getModule(requestedModule);
        InstanceHolder instanceHolder = module.getInstanceHolder(instance);
        instanceHolder.getContainerService().forwardToServer(hrequest, hresponse);
    }

    @Override
    public boolean isLoadBalancingInstance(String moduleName, int instance) {
        Module module = this.getModule(moduleName);
        InstanceHolder instanceHolder = module.getInstanceHolder(instance);
        return instanceHolder.isLoadBalancingInstance();
    }

    @Override
    public boolean expectsGeneratedStartRequests(String moduleName, int instance) {
        Module module = this.getModule(moduleName);
        InstanceHolder instanceHolder = module.getInstanceHolder(instance);
        return instanceHolder.expectsGeneratedStartRequest();
    }

    @Override
    public int getPort(String moduleName, int instance) {
        Module module = this.getModule(moduleName);
        InstanceHolder instanceHolder = module.getInstanceHolder(instance);
        return instanceHolder.getContainerService().getPort();
    }
}

