/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.WebXml;
import java.io.File;

public class WebModule {
    public static final String DEFAULT_MODULE_NAME = "default";
    private final File applicationDirectory;
    private final AppEngineWebXml appEngineWebXml;
    private final File appEngineWebXmlFile;
    private final WebXml webXml;
    private final File webXmlFile;
    private final String contextRoot;

    public static String getModuleName(AppEngineWebXml appEngineWebXml) {
        String module = appEngineWebXml.getModule();
        if (module == null) {
            module = appEngineWebXml.getService();
        }
        if (module == null || CharMatcher.whitespace().matchesAllOf(module)) {
            return DEFAULT_MODULE_NAME;
        }
        return module.trim();
    }

    WebModule(File applicationDirectory, AppEngineWebXml appEngineWebXml, File appEngineWebXmlFile, WebXml webXml, File webXmlFile, String contextRoot) {
        this.applicationDirectory = applicationDirectory;
        this.appEngineWebXml = appEngineWebXml;
        this.appEngineWebXmlFile = appEngineWebXmlFile;
        this.webXml = webXml;
        this.webXmlFile = webXmlFile;
        this.contextRoot = contextRoot;
    }

    public File getApplicationDirectory() {
        return this.applicationDirectory;
    }

    public AppEngineWebXml getAppEngineWebXml() {
        return this.appEngineWebXml;
    }

    public File getAppEngineWebXmlFile() {
        return this.appEngineWebXmlFile;
    }

    public WebXml getWebXml() {
        return this.webXml;
    }

    public File getWebXmlFile() {
        return this.webXmlFile;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public String getModuleName() {
        return WebModule.getModuleName(this.appEngineWebXml);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appEngineWebXml == null ? 0 : this.appEngineWebXml.hashCode());
        result = 31 * result + (this.appEngineWebXmlFile == null ? 0 : this.appEngineWebXmlFile.hashCode());
        result = 31 * result + (this.applicationDirectory == null ? 0 : this.applicationDirectory.hashCode());
        result = 31 * result + (this.contextRoot == null ? 0 : this.contextRoot.hashCode());
        result = 31 * result + (this.webXml == null ? 0 : this.webXml.hashCode());
        result = 31 * result + (this.webXmlFile == null ? 0 : this.webXmlFile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebModule other = (WebModule)obj;
        if (this.appEngineWebXml == null ? other.appEngineWebXml != null : !this.appEngineWebXml.equals(other.appEngineWebXml)) {
            return false;
        }
        if (this.appEngineWebXmlFile == null ? other.appEngineWebXmlFile != null : !this.appEngineWebXmlFile.equals(other.appEngineWebXmlFile)) {
            return false;
        }
        if (this.applicationDirectory == null ? other.applicationDirectory != null : !this.applicationDirectory.equals(other.applicationDirectory)) {
            return false;
        }
        if (this.contextRoot == null ? other.contextRoot != null : !this.contextRoot.equals(other.contextRoot)) {
            return false;
        }
        if (this.webXml == null ? other.webXml != null : !this.webXml.equals(other.webXml)) {
            return false;
        }
        return !(this.webXmlFile == null ? other.webXmlFile != null : !this.webXmlFile.equals(other.webXmlFile));
    }

    public String toString() {
        String string = String.valueOf(this.applicationDirectory);
        String string2 = String.valueOf(this.appEngineWebXml);
        String string3 = String.valueOf(this.appEngineWebXmlFile);
        String string4 = String.valueOf(this.webXml);
        String string5 = String.valueOf(this.webXmlFile);
        String string6 = this.contextRoot;
        return new StringBuilder(103 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length() + String.valueOf(string6).length()).append("WebModule: applicationDirectory=").append(string).append(" appEngineWebXml=").append(string2).append(" appEngineWebXmlFile=").append(string3).append(" webXml=").append(string4).append(" webXmlFile=").append(string5).append(" contextRoot=").append(string6).toString();
    }
}

