/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.dev.FileMetadata;
import com.google.appengine.api.files.dev.LocalFileService;
import com.google.appengine.api.files.dev.ParsedFileName;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class GSFile
extends FileMetadata {
    public static final String FILE_SYSTEM = AppEngineFile.FileSystem.GS.getName();
    public static final String CREATION_HANDLE_PREFIX = "writable:";
    static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    static final String PARAMETER_MIME_TYPE = "content_type";
    static final String PARAMETER_CANNED_ACL = "acl";
    static final String PARAMETER_CONTENT_ENCODING = "content_encoding";
    static final String PARAMETER_CONTENT_DISPOSITION = "content_disposition";
    static final String PARAMETER_CACHE_CONTROL = "cache_control";
    private final LocalFileService localFileService;
    private final Clock clock;
    private final String mimeType;

    private static String urlEncodeString(String string) {
        try {
            return URLEncoder.encode(string, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildWritablePath(String randomString, String fileName) {
        ParsedFileName parsedName = new ParsedFileName(fileName);
        String string = parsedName.getFileSystem();
        String string2 = GSFile.urlEncodeString(parsedName.getNamePart());
        return new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(randomString).length() + String.valueOf(string2).length()).append("/").append(string).append("/").append(CREATION_HANDLE_PREFIX).append(randomString).append("?name=").append(string2).toString();
    }

    GSFile(String readName, String appendName, FileServicePb.FileContentType.ContentType contentType, boolean finalized, LocalFileService localFileService, Clock clock, Map<String, String> parameters) {
        super(readName, appendName, contentType);
        this.localFileService = localFileService;
        this.clock = clock;
        this.finalized = finalized;
        this.mimeType = parameters != null ? parameters.get(PARAMETER_MIME_TYPE) : null;
    }

    private static Map<String, String> filterOutUserMetadata(Map<String, String> sourceMap) {
        Preconditions.checkNotNull(sourceMap);
        HashMap<String, String> filteredMap = new HashMap<String, String>();
        for (String key : sourceMap.keySet()) {
            if (key.startsWith("x-goog-meta-")) continue;
            filteredMap.put(key, sourceMap.get(key));
        }
        return filteredMap;
    }

    public static FileMetadata create(LocalFileService localFileService, Clock clock, String fileName, String randomString, FileServicePb.FileContentType.ContentType contentType, Map<String, String> parameters) {
        GSFile.checkParameters(GSFile.filterOutUserMetadata(parameters), PARAMETER_CANNED_ACL, PARAMETER_MIME_TYPE, PARAMETER_CONTENT_ENCODING, PARAMETER_CONTENT_DISPOSITION, PARAMETER_CACHE_CONTROL);
        String appendName = GSFile.buildWritablePath(randomString, fileName);
        boolean notFinalized = false;
        return new GSFile(fileName, appendName, contentType, notFinalized, localFileService, clock, parameters);
    }

    protected static FileMetadata newFinalizedInstance(LocalFileService localFileService, Clock clock, ParsedFileName parsedName) {
        if (parsedName.getNamePart().startsWith(CREATION_HANDLE_PREFIX)) {
            throw new ApiProxy.ApplicationException(FileServicePb.FileServiceErrors.ErrorCode.INVALID_FILE_NAME.getNumber(), "cannot read from an appendable file");
        }
        boolean finalized = true;
        String noAppendName = null;
        FileServicePb.FileContentType.ContentType noContentType = null;
        Map<String, String> noParameters = null;
        return new GSFile(parsedName.getFullPath(), noAppendName, noContentType, finalized, localFileService, clock, noParameters);
    }

    @Override
    public BlobInfo getBlobInfo() {
        Entity blobInfoEntity;
        Preconditions.checkState((boolean)this.finalized, (Object)"File is not finalized");
        BlobKey blobKey = this.localFileService.getBlobstore().createGsBlobKey(this.readName);
        DatastoreService datastore = this.localFileService.getDatastore();
        Key key = this.getGsKey(blobKey);
        try {
            blobInfoEntity = datastore.get(key);
        }
        catch (EntityNotFoundException e) {
            String string = String.valueOf(this.readName);
            throw new ApiProxy.ApplicationException(105, string.length() != 0 ? "File's blobInfo can't be found in datastore ".concat(string) : new String("File's blobInfo can't be found in datastore "));
        }
        BlobInfo blobInfo = new BlobInfoFactory().createBlobInfo(blobInfoEntity);
        return blobInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Key getGsKey(BlobKey blobKey) {
        String origNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            Key key = KeyFactory.createKey((String)"__GsFileInfo__", (String)blobKey.getKeyString());
            return key;
        }
        finally {
            NamespaceManager.set((String)origNamespace);
        }
    }

    @Override
    public void setFinalized() {
        super.setFinalized();
        BlobKey blobKey = this.localFileService.getBlobstore().createGsBlobKey(this.readName);
        this.saveBlobInfo(this.localFileService.getDatastore(), blobKey, "__GsFileInfo__", this.mimeType, this.clock.getCurrentTime(), this.readName, null);
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        BlobKey key = this.localFileService.getBlobstore().createGsBlobKey(this.readName);
        return this.localFileService.getBlobStorage().storeBlob(key);
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        BlobKey key = this.localFileService.getBlobstore().createGsBlobKey(this.readName);
        return this.localFileService.getBlobStorage().fetchBlob(key);
    }
}

