/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.dev.LuceneQueryTreeContext;
import com.google.appengine.api.search.dev.LuceneQueryTreeVisitor;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.SimpleFacet;
import com.google.appengine.api.search.query.QueryParserFactory;
import com.google.appengine.api.search.query.QueryTreeBuilder;
import com.google.appengine.api.search.query.QueryTreeContext;
import com.google.appengine.api.search.query.QueryTreeException;
import com.google.appengine.api.search.query.QueryTreeVisitor;
import com.google.appengine.api.search.query.QueryTreeWalker;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.tree.CommonTree;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanClause;
import com.google.appengine.repackaged.org.apache.lucene.search.BooleanQuery;
import com.google.appengine.repackaged.org.apache.lucene.search.Query;
import com.google.apphosting.api.search.DocumentPb;
import java.util.Map;
import java.util.Set;

class LuceneQueryBuilder {
    private final Map<String, Set<DocumentPb.FieldValue.ContentType>> allFieldTypes;

    LuceneQueryBuilder(Map<String, Set<DocumentPb.FieldValue.ContentType>> allFieldTypes) {
        this.allFieldTypes = allFieldTypes;
    }

    Query parse(SearchServicePb.SearchParams searchParams) {
        Query ret;
        String query = searchParams.getQuery();
        try {
            CommonTree tree = new QueryTreeBuilder(new QueryParserFactory()).parse(query);
            if (tree == null) {
                throw new SearchQueryException("Null query not expected");
            }
            if ((tree = QueryTreeWalker.simplify((Tree)tree)).getChildCount() == 0) {
                ret = LuceneUtils.getMatchAnyDocumentQuery();
            } else {
                LuceneQueryTreeVisitor visitor = new LuceneQueryTreeVisitor(this.allFieldTypes);
                QueryTreeWalker walker = new QueryTreeWalker((QueryTreeVisitor)visitor);
                LuceneQueryTreeContext rootContext = LuceneQueryTreeContext.newRootContext();
                walker.walk((Tree)tree, (QueryTreeContext)rootContext);
                ret = rootContext.getQuery();
            }
        }
        catch (RecognitionException e) {
            String message = String.format("WARNING: query error at line %d:%d", e.line, e.charPositionInLine);
            SearchQueryException e2 = new SearchQueryException(message);
            e2.initCause((Throwable)e);
            throw e2;
        }
        catch (QueryTreeException e) {
            SearchQueryException e2 = new SearchQueryException(e.getMessage());
            e2.initCause((Throwable)e);
            throw e2;
        }
        if (searchParams.getFacetRefinementCount() != 0) {
            BooleanQuery combinedQuery = new BooleanQuery();
            combinedQuery.add(ret, BooleanClause.Occur.MUST);
            combinedQuery.add(SimpleFacet.getRefinementQuery(searchParams), BooleanClause.Occur.MUST);
            ret = combinedQuery;
        }
        return ret;
    }
}

