/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.query.QueryParserFactory;
import com.google.appengine.api.search.query.QueryTreeBuilder;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.tree.CommonTree;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import java.util.ArrayList;
import java.util.List;

public class SnippetExpressionQueryParser {
    private final List<String> tokens = new ArrayList<String>();
    private final String fieldName;

    public SnippetExpressionQueryParser(String fieldName) {
        this.fieldName = fieldName == null ? "" : fieldName;
    }

    public List<String> parse(String query) {
        try {
            CommonTree tree = new QueryTreeBuilder(new QueryParserFactory()).parse(query);
            if (tree.getChildCount() == 0) {
                return null;
            }
            this.getTokens((Tree)tree);
            return this.tokens;
        }
        catch (RecognitionException e) {
            String string = String.valueOf(query);
            throw new SearchQueryException(string.length() != 0 ? "Failed to parse ".concat(string) : new String("Failed to parse "));
        }
    }

    private void textQuery(Tree tree) {
        switch (tree.getChild(0).getType()) {
            case 32: {
                this.tokens.add(tree.getChild(1).getText());
                break;
            }
            case 13: {
                for (int i = 0; i < tree.getChild(1).getChildCount(); ++i) {
                    String token = tree.getChild(1).getChild(i).getText().trim();
                    if (this.tokens.isEmpty()) continue;
                    this.tokens.add(token);
                }
                break;
            }
        }
    }

    private void getTokens(Tree tree) {
        if (tree == null) {
            throw new SearchQueryException("Unexpected null node encountered");
        }
        switch (tree.getType()) {
            case 5: 
            case 6: 
            case 12: 
            case 14: {
                for (int i = 0; i < tree.getChildCount(); ++i) {
                    this.getTokens(tree.getChild(i));
                }
                break;
            }
            case 15: {
                this.textQuery(tree);
                break;
            }
            case 22: 
            case 23: {
                Tree lhs = tree.getChild(0);
                if (lhs.getType() == 15) {
                    if (!lhs.getChild(1).getText().equals(this.fieldName)) break;
                    this.getTokens(tree.getChild(1));
                    break;
                }
                if (lhs.getType() != 10) break;
                this.getTokens(tree.getChild(1));
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            default: {
                int n = tree.getType();
                throw new SearchQueryException(new StringBuilder(32).append("Not yet implemented: ").append(n).toString());
            }
        }
    }
}

