/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.lucene.analysis;

import com.google.appengine.repackaged.org.apache.lucene.analysis.Analyzer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.CharArraySet;
import com.google.appengine.repackaged.org.apache.lucene.analysis.LowerCaseTokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.StopFilter;
import com.google.appengine.repackaged.org.apache.lucene.analysis.TokenStream;
import com.google.appengine.repackaged.org.apache.lucene.analysis.Tokenizer;
import com.google.appengine.repackaged.org.apache.lucene.analysis.WordlistLoader;
import com.google.appengine.repackaged.org.apache.lucene.util.Version;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Set;

public final class StopAnalyzer
extends Analyzer {
    private final Set stopWords;
    private final boolean useDefaultStopPositionIncrement;
    private final boolean enablePositionIncrements;
    public static final String[] ENGLISH_STOP_WORDS = new String[]{"a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    public static final Set ENGLISH_STOP_WORDS_SET;

    public StopAnalyzer() {
        this.stopWords = ENGLISH_STOP_WORDS_SET;
        this.useDefaultStopPositionIncrement = true;
        this.enablePositionIncrements = false;
    }

    public StopAnalyzer(Version matchVersion) {
        this.stopWords = ENGLISH_STOP_WORDS_SET;
        this.useDefaultStopPositionIncrement = false;
        this.enablePositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
    }

    public StopAnalyzer(boolean enablePositionIncrements) {
        this.stopWords = ENGLISH_STOP_WORDS_SET;
        this.enablePositionIncrements = enablePositionIncrements;
        this.useDefaultStopPositionIncrement = false;
    }

    public StopAnalyzer(Set stopWords) {
        this.stopWords = stopWords;
        this.useDefaultStopPositionIncrement = true;
        this.enablePositionIncrements = false;
    }

    public StopAnalyzer(Version matchVersion, Set stopWords) {
        this.stopWords = stopWords;
        this.useDefaultStopPositionIncrement = false;
        this.enablePositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
    }

    public StopAnalyzer(Set stopWords, boolean enablePositionIncrements) {
        this.stopWords = stopWords;
        this.enablePositionIncrements = enablePositionIncrements;
        this.useDefaultStopPositionIncrement = false;
    }

    public StopAnalyzer(String[] stopWords) {
        this.stopWords = StopFilter.makeStopSet(stopWords);
        this.useDefaultStopPositionIncrement = true;
        this.enablePositionIncrements = false;
    }

    public StopAnalyzer(String[] stopWords, boolean enablePositionIncrements) {
        this.stopWords = StopFilter.makeStopSet(stopWords);
        this.enablePositionIncrements = enablePositionIncrements;
        this.useDefaultStopPositionIncrement = false;
    }

    public StopAnalyzer(File stopwordsFile) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwordsFile);
        this.useDefaultStopPositionIncrement = true;
        this.enablePositionIncrements = false;
    }

    public StopAnalyzer(File stopwordsFile, boolean enablePositionIncrements) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwordsFile);
        this.enablePositionIncrements = enablePositionIncrements;
        this.useDefaultStopPositionIncrement = false;
    }

    public StopAnalyzer(Version matchVersion, File stopwordsFile) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwordsFile);
        this.enablePositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
        this.useDefaultStopPositionIncrement = false;
    }

    public StopAnalyzer(Reader stopwords) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwords);
        this.useDefaultStopPositionIncrement = true;
        this.enablePositionIncrements = false;
    }

    public StopAnalyzer(Reader stopwords, boolean enablePositionIncrements) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwords);
        this.enablePositionIncrements = enablePositionIncrements;
        this.useDefaultStopPositionIncrement = false;
    }

    public StopAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwords);
        this.enablePositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
        this.useDefaultStopPositionIncrement = false;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        if (this.useDefaultStopPositionIncrement) {
            return new StopFilter((TokenStream)new LowerCaseTokenizer(reader), this.stopWords);
        }
        return new StopFilter(this.enablePositionIncrements, (TokenStream)new LowerCaseTokenizer(reader), this.stopWords);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new LowerCaseTokenizer(reader);
            streams.result = this.useDefaultStopPositionIncrement ? new StopFilter((TokenStream)streams.source, this.stopWords) : new StopFilter(this.enablePositionIncrements, (TokenStream)streams.source, this.stopWords);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    static {
        String[] stopWords = new String[]{"a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
        CharArraySet stopSet = new CharArraySet(stopWords.length, false);
        stopSet.addAll(Arrays.asList(stopWords));
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(stopSet);
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

